/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.services.kendra.model.SourceDocument;
import com.amazonaws.services.kendra.model.transform.DocumentAttributeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class SourceDocumentJsonUnmarshaller
implements Unmarshaller<SourceDocument, JsonUnmarshallerContext> {
    private static SourceDocumentJsonUnmarshaller instance;

    public SourceDocument unmarshall(JsonUnmarshallerContext context) throws Exception {
        SourceDocument sourceDocument = new SourceDocument();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DocumentId", targetDepth)) {
                    context.nextToken();
                    sourceDocument.setDocumentId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SuggestionAttributes", targetDepth)) {
                    context.nextToken();
                    sourceDocument.setSuggestionAttributes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AdditionalAttributes", targetDepth)) {
                    context.nextToken();
                    sourceDocument.setAdditionalAttributes(new ListUnmarshaller((Unmarshaller)DocumentAttributeJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return sourceDocument;
    }

    public static SourceDocumentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceDocumentJsonUnmarshaller();
        }
        return instance;
    }
}

