/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.processor.api.ContextualFixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

class KStreamPeek<K, V>
implements FixedKeyProcessorSupplier<K, V, V> {
    private final ForeachAction<K, V> action;

    public KStreamPeek(ForeachAction<K, V> action) {
        this.action = action;
    }

    @Override
    public FixedKeyProcessor<K, V, V> get() {
        return new KStreamPeekProcessor();
    }

    private class KStreamPeekProcessor
    extends ContextualFixedKeyProcessor<K, V, V> {
        private KStreamPeekProcessor() {
        }

        @Override
        public void process(FixedKeyRecord<K, V> record) {
            KStreamPeek.this.action.apply(record.key(), record.value());
            this.context().forward(record);
        }
    }
}

