/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class TransactionLogValue
implements ApiMessage {
    long producerId;
    long previousProducerId;
    long nextProducerId;
    short producerEpoch;
    int transactionTimeoutMs;
    byte transactionStatus;
    List<PartitionsSchema> transactionPartitions;
    long transactionLastUpdateTimestampMs;
    long transactionStartTimestampMs;
    short clientTransactionVersion;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "Producer id in use by the transactional id."), new Field("producer_epoch", (Type)Type.INT16, "Epoch associated with the producer id."), new Field("transaction_timeout_ms", (Type)Type.INT32, "Transaction timeout in milliseconds."), new Field("transaction_status", (Type)Type.INT8, "TransactionState the transaction is in."), new Field("transaction_partitions", (Type)ArrayOf.nullable((Type)PartitionsSchema.SCHEMA_0), "Partitions involved in the transaction."), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, "Time the transaction was last updated."), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, "Time the transaction was started.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "Producer id in use by the transactional id."), new Field("producer_epoch", (Type)Type.INT16, "Epoch associated with the producer id."), new Field("transaction_timeout_ms", (Type)Type.INT32, "Transaction timeout in milliseconds."), new Field("transaction_status", (Type)Type.INT8, "TransactionState the transaction is in."), new Field("transaction_partitions", (Type)CompactArrayOf.nullable((Type)PartitionsSchema.SCHEMA_1), "Partitions involved in the transaction."), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, "Time the transaction was last updated."), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, "Time the transaction was started."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("previous_producer_id", (Type)Type.INT64, "Producer id used by the last committed transaction."), 1, new Field("next_producer_id", (Type)Type.INT64, "Latest producer ID sent to the producer for the given transactional id."), 2, new Field("client_transaction_version", (Type)Type.INT16, "The transaction version used by the client.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public TransactionLogValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public TransactionLogValue() {
        this.producerId = 0L;
        this.previousProducerId = -1L;
        this.nextProducerId = -1L;
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 0;
        this.transactionStatus = 0;
        this.transactionPartitions = new ArrayList<PartitionsSchema>(0);
        this.transactionLastUpdateTimestampMs = 0L;
        this.transactionStartTimestampMs = 0L;
        this.clientTransactionVersion = 0;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version) {
        this.producerId = _readable.readLong();
        this.previousProducerId = -1L;
        this.nextProducerId = -1L;
        this.producerEpoch = _readable.readShort();
        this.transactionTimeoutMs = _readable.readInt();
        this.transactionStatus = _readable.readByte();
        if (_version >= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.transactionPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionsSchema(_readable, _version));
                }
                this.transactionPartitions = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.transactionPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<PartitionsSchema>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionsSchema(_readable, _version));
                }
                this.transactionPartitions = newCollection;
            }
        }
        this.transactionLastUpdateTimestampMs = _readable.readLong();
        this.transactionStartTimestampMs = _readable.readLong();
        this.clientTransactionVersion = 0;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.previousProducerId = _readable.readLong();
                        continue block7;
                    }
                    case 1: {
                        this.nextProducerId = _readable.readLong();
                        continue block7;
                    }
                    case 2: {
                        this.clientTransactionVersion = _readable.readShort();
                        continue block7;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeLong(this.producerId);
        if (_version >= 1) {
            if (this.previousProducerId != -1L) {
                ++_numTaggedFields;
            }
        } else if (this.previousProducerId != -1L) {
            throw new UnsupportedVersionException("Attempted to write a non-default previousProducerId at version " + _version);
        }
        if (_version >= 1) {
            if (this.nextProducerId != -1L) {
                ++_numTaggedFields;
            }
        } else if (this.nextProducerId != -1L) {
            throw new UnsupportedVersionException("Attempted to write a non-default nextProducerId at version " + _version);
        }
        _writable.writeShort(this.producerEpoch);
        _writable.writeInt(this.transactionTimeoutMs);
        _writable.writeByte(this.transactionStatus);
        if (_version >= 1) {
            if (this.transactionPartitions == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.transactionPartitions.size() + 1);
                for (PartitionsSchema transactionPartitionsElement : this.transactionPartitions) {
                    transactionPartitionsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.transactionPartitions == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.transactionPartitions.size());
            for (PartitionsSchema transactionPartitionsElement : this.transactionPartitions) {
                transactionPartitionsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeLong(this.transactionLastUpdateTimestampMs);
        _writable.writeLong(this.transactionStartTimestampMs);
        if (_version >= 1) {
            if (this.clientTransactionVersion != 0) {
                ++_numTaggedFields;
            }
        } else if (this.clientTransactionVersion != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default clientTransactionVersion at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (this.previousProducerId != -1L) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.previousProducerId);
            }
            if (this.nextProducerId != -1L) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.nextProducerId);
            }
            if (this.clientTransactionVersion != 0) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.clientTransactionVersion);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(8);
        if (_version >= 1 && this.previousProducerId != -1L) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (_version >= 1 && this.nextProducerId != -1L) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        _size.addBytes(2);
        _size.addBytes(4);
        _size.addBytes(1);
        if (this.transactionPartitions == null) {
            if (_version >= 1) {
                _size.addBytes(1);
            } else {
                _size.addBytes(4);
            }
        } else {
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.transactionPartitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            for (PartitionsSchema transactionPartitionsElement : this.transactionPartitions) {
                transactionPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        _size.addBytes(8);
        _size.addBytes(8);
        if (_version >= 1 && this.clientTransactionVersion != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionLogValue)) {
            return false;
        }
        TransactionLogValue other = (TransactionLogValue)obj;
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.previousProducerId != other.previousProducerId) {
            return false;
        }
        if (this.nextProducerId != other.nextProducerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        if (this.transactionTimeoutMs != other.transactionTimeoutMs) {
            return false;
        }
        if (this.transactionStatus != other.transactionStatus) {
            return false;
        }
        if (this.transactionPartitions == null ? other.transactionPartitions != null : !this.transactionPartitions.equals(other.transactionPartitions)) {
            return false;
        }
        if (this.transactionLastUpdateTimestampMs != other.transactionLastUpdateTimestampMs) {
            return false;
        }
        if (this.transactionStartTimestampMs != other.transactionStartTimestampMs) {
            return false;
        }
        if (this.clientTransactionVersion != other.clientTransactionVersion) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + ((int)(this.previousProducerId >> 32) ^ (int)this.previousProducerId);
        hashCode = 31 * hashCode + ((int)(this.nextProducerId >> 32) ^ (int)this.nextProducerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + this.transactionTimeoutMs;
        hashCode = 31 * hashCode + this.transactionStatus;
        hashCode = 31 * hashCode + (this.transactionPartitions == null ? 0 : this.transactionPartitions.hashCode());
        hashCode = 31 * hashCode + ((int)(this.transactionLastUpdateTimestampMs >> 32) ^ (int)this.transactionLastUpdateTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.transactionStartTimestampMs >> 32) ^ (int)this.transactionStartTimestampMs);
        hashCode = 31 * hashCode + this.clientTransactionVersion;
        return hashCode;
    }

    public TransactionLogValue duplicate() {
        TransactionLogValue _duplicate = new TransactionLogValue();
        _duplicate.producerId = this.producerId;
        _duplicate.previousProducerId = this.previousProducerId;
        _duplicate.nextProducerId = this.nextProducerId;
        _duplicate.producerEpoch = this.producerEpoch;
        _duplicate.transactionTimeoutMs = this.transactionTimeoutMs;
        _duplicate.transactionStatus = this.transactionStatus;
        if (this.transactionPartitions == null) {
            _duplicate.transactionPartitions = null;
        } else {
            ArrayList<PartitionsSchema> newTransactionPartitions = new ArrayList<PartitionsSchema>(this.transactionPartitions.size());
            for (PartitionsSchema _element : this.transactionPartitions) {
                newTransactionPartitions.add(_element.duplicate());
            }
            _duplicate.transactionPartitions = newTransactionPartitions;
        }
        _duplicate.transactionLastUpdateTimestampMs = this.transactionLastUpdateTimestampMs;
        _duplicate.transactionStartTimestampMs = this.transactionStartTimestampMs;
        _duplicate.clientTransactionVersion = this.clientTransactionVersion;
        return _duplicate;
    }

    public String toString() {
        return "TransactionLogValue(producerId=" + this.producerId + ", previousProducerId=" + this.previousProducerId + ", nextProducerId=" + this.nextProducerId + ", producerEpoch=" + this.producerEpoch + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ", transactionStatus=" + this.transactionStatus + ", transactionPartitions=" + (this.transactionPartitions == null ? "null" : MessageUtil.deepToString(this.transactionPartitions.iterator())) + ", transactionLastUpdateTimestampMs=" + this.transactionLastUpdateTimestampMs + ", transactionStartTimestampMs=" + this.transactionStartTimestampMs + ", clientTransactionVersion=" + this.clientTransactionVersion + ")";
    }

    public long producerId() {
        return this.producerId;
    }

    public long previousProducerId() {
        return this.previousProducerId;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public byte transactionStatus() {
        return this.transactionStatus;
    }

    public List<PartitionsSchema> transactionPartitions() {
        return this.transactionPartitions;
    }

    public long transactionLastUpdateTimestampMs() {
        return this.transactionLastUpdateTimestampMs;
    }

    public long transactionStartTimestampMs() {
        return this.transactionStartTimestampMs;
    }

    public short clientTransactionVersion() {
        return this.clientTransactionVersion;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TransactionLogValue setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public TransactionLogValue setPreviousProducerId(long v) {
        this.previousProducerId = v;
        return this;
    }

    public TransactionLogValue setNextProducerId(long v) {
        this.nextProducerId = v;
        return this;
    }

    public TransactionLogValue setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public TransactionLogValue setTransactionTimeoutMs(int v) {
        this.transactionTimeoutMs = v;
        return this;
    }

    public TransactionLogValue setTransactionStatus(byte v) {
        this.transactionStatus = v;
        return this;
    }

    public TransactionLogValue setTransactionPartitions(List<PartitionsSchema> v) {
        this.transactionPartitions = v;
        return this;
    }

    public TransactionLogValue setTransactionLastUpdateTimestampMs(long v) {
        this.transactionLastUpdateTimestampMs = v;
        return this;
    }

    public TransactionLogValue setTransactionStartTimestampMs(long v) {
        this.transactionStartTimestampMs = v;
        return this;
    }

    public TransactionLogValue setClientTransactionVersion(short v) {
        this.clientTransactionVersion = v;
        return this;
    }

    public static class PartitionsSchema
    implements Message {
        String topic;
        List<Integer> partitionIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "Topic involved in the transaction."), new Field("partition_ids", (Type)new ArrayOf((Type)Type.INT32), "Partition ids involved in the transaction.")});
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "Topic involved in the transaction."), new Field("partition_ids", (Type)new CompactArrayOf((Type)Type.INT32), "Partition ids involved in the transaction."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PartitionsSchema(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionsSchema() {
            this.topic = "";
            this.partitionIds = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public final void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionsSchema");
            }
            int length = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIds was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topic);
            if (_version >= 1) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.partitionIds.size() + 1);
            } else {
                _writable.writeInt(this.partitionIds.size());
            }
            _stringBytes = this.partitionIds.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIdsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIdsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 1) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionsSchema");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
            if (_version >= 1) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitionIds.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitionIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionsSchema)) {
                return false;
            }
            PartitionsSchema other = (PartitionsSchema)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitionIds == null ? other.partitionIds != null : !this.partitionIds.equals(other.partitionIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionIds == null ? 0 : this.partitionIds.hashCode());
            return hashCode;
        }

        public PartitionsSchema duplicate() {
            PartitionsSchema _duplicate = new PartitionsSchema();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitionIds = new ArrayList<Integer>(this.partitionIds.size());
            for (Integer _element : this.partitionIds) {
                newPartitionIds.add(_element);
            }
            _duplicate.partitionIds = newPartitionIds;
            return _duplicate;
        }

        public String toString() {
            return "PartitionsSchema(topic=" + (String)(this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionIds=" + MessageUtil.deepToString(this.partitionIds.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionIds() {
            return this.partitionIds;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionsSchema setTopic(String v) {
            this.topic = v;
            return this;
        }

        public PartitionsSchema setPartitionIds(List<Integer> v) {
            this.partitionIds = v;
            return this;
        }
    }
}

