/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005uu!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u001b\u0001\u0005C\u0001\"\u0012\u0003\u0003\u0006\u0004%IA\u0012\u0005\t\u001b\u0012\u0011\t\u0011)A\u0005\u000f\"AQ\u0007\u0002BC\u0002\u0013%a\n\u0003\u0005S\t\t\u0005\t\u0015!\u0003P\u0011!\u0019FA!b\u0001\n\u0013!\u0006\u0002C.\u0005\u0005\u0003\u0005\u000b\u0011B+\t\u0011q#!Q1A\u0005\nuC\u0001\"\u001b\u0003\u0003\u0002\u0003\u0006IA\u0018\u0005\tU\u0012\u0011)\u0019!C\u0005W\"AQ\u000f\u0002B\u0001B\u0003%A\u000eC\u0003*\t\u0011\u0005a\u000fC\u0003~\t\u0011Ec\u0010C\u0004\u0002\u0012\u0011!I!a\u0005\t\u000f\u0005]A\u0001\"\u0015\u0002\u001a!9\u0011\u0011\u0007\u0003\u0005B\u0005M\u0002bBA.\t\u0011\u0005\u0011Q\f\u0005\b\u00037\"A\u0011AA5\u0011\u001d\t\t\t\u0002C\u0001\u0003\u0007Cq!!!\u0005\t\u0003\tI\tC\u0004\u0002\u000e\u0012!\t!a$\u0002=\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\fW*\u00198bO\u0016\u0014(BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\u000e\u0003=\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\fW*\u00198bO\u0016\u00148CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aH\u0001\u000fi\"\u0014x\u000e\u001e;mKRKW.Z't)\ri\u0003g\u0010\t\u0003I9J!aL\u0013\u0003\t1{gn\u001a\u0005\u0006c\r\u0001\rAM\u0001\u0002KB\u00111'P\u0007\u0002i)\u0011QGN\u0001\b[\u0016$(/[2t\u0015\t9\u0004(\u0001\u0004d_6lwN\u001c\u0006\u0003;eR!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO&\u0011a\b\u000e\u0002\u0018#V|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001Q\u0002A\u00025\na\u0001^5nK6\u001b8C\u0001\u0003C!\t\u00013)\u0003\u0002E5\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002F\u0015*\u00111\u0004O\u0005\u0003\u0019&\u0013\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002*\u0012a\u0014\t\u0003gAK!!\u0015\u001b\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#A+\u0011\u0005YKV\"A,\u000b\u0005a3\u0014!B;uS2\u001c\u0018B\u0001.X\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#\u00010\u0011\u0005}3gB\u00011e!\t\tW%D\u0001c\u0015\t\u0019g$\u0001\u0004=e>|GOP\u0005\u0003K\u0016\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q-J\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013!D9v_R\f7)\u00197mE\u0006\u001c7.F\u0001m!\r!Sn\\\u0005\u0003]\u0016\u0012aa\u00149uS>t\u0007C\u00019t\u001b\u0005\t(B\u0001:K\u0003\u0015\tXo\u001c;b\u0013\t!\u0018OA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\brk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0015\r]D\u0018P_>}!\t\u0001C\u0001C\u0003F\u001f\u0001\u0007q\tC\u00036\u001f\u0001\u0007q\nC\u0003T\u001f\u0001\u0007Q\u000bC\u0003]\u001f\u0001\u0007a\fC\u0003k\u001f\u0001\u0007A.A\u000bdY&,g\u000e^)v_R\fW*\u001a;sS\u000et\u0015-\\3\u0015\u0007}\f9\u0001\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001\u001c\n\u0007\u0005\u0015aG\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Dq!!\u0003\u0011\u0001\u0004\tY!A\brk>$\u0018-T3ue&\u001cG+Y4t!\u0015y\u0016Q\u00020_\u0013\r\ty\u0001\u001b\u0002\u0004\u001b\u0006\u0004\u0018\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\rF\u0002\u0000\u0003+Aq!!\u0003\u0012\u0001\u0004\tY!\u0001\u000bsK\u001eL7\u000f^3s#V|G/Y'fiJL7m\u001d\u000b\u0005\u00037\ti\u0003\u0006\u0003\u0002\u001e\u0005\r\u0002c\u0001\u0013\u0002 %\u0019\u0011\u0011E\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003K\u0011\u0002\u0019AA\u0014\u0003\u0019\u0019XM\\:peB\u00191'!\u000b\n\u0007\u0005-BG\u0001\u0004TK:\u001cxN\u001d\u0005\b\u0003_\u0011\u0002\u0019AA\u0006\u0003)iW\r\u001e:jGR\u000bwm]\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u000b\u0003k\tY$a\u0013\u0002P\u0005e\u0003c\u0001\u0013\u00028%\u0019\u0011\u0011H\u0013\u0003\u0007%sG\u000fC\u0004\u0002>M\u0001\r!a\u0010\u0002\u000fM,7o]5p]B!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fa\nqA\\3uo>\u00148.\u0003\u0003\u0002J\u0005\r#aB*fgNLwN\u001c\u0005\u0007\u0003\u001b\u001a\u0002\u0019\u00010\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!!\u0015\u0014\u0001\u0004\t\u0019&A\u0003wC2,X\rE\u0002%\u0003+J1!a\u0016&\u0005\u0019!u.\u001e2mK\")\u0001i\u0005a\u0001[\u0005\tb.Z<TiJL7\r^)v_R\fgi\u001c:\u0015\r\u0005}\u0013QMA4!\r\u0001\u0013\u0011M\u0005\u0004\u0003GR\"aF\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u0011\u001d\ti\u0004\u0006a\u0001\u0003\u007fAa!!\u0014\u0015\u0001\u0004qF\u0003BA0\u0003WBq!!\u001c\u0016\u0001\u0004\ty'A\u0004sKF,Xm\u001d;\u0011\t\u0005E\u00141\u0010\b\u0005\u0003g\n9(\u0004\u0002\u0002v)\u0019\u0011Q\t\u000f\n\t\u0005e\u0014QO\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\ti(a \u0003\u000fI+\u0017/^3ti*!\u0011\u0011PA;\u0003UqWm\u001e)fe6L7o]5wKF+x\u000e^1G_J$b!a\u0018\u0002\u0006\u0006\u001d\u0005bBA\u001f-\u0001\u0007\u0011q\b\u0005\u0007\u0003\u001b2\u0002\u0019\u00010\u0015\t\u0005}\u00131\u0012\u0005\b\u0003[:\u0002\u0019AA8\u0003-qWm^)v_R\fgi\u001c:\u0015\r\u0005}\u0013\u0011SAJ\u0011\u001d\ti\u0007\u0007a\u0001\u0003_Bq!!&\u0019\u0001\u0004\t9*\u0001\ntiJL7\r^*j]\u000e,g+\u001a:tS>t\u0007c\u0001\u0013\u0002\u001a&\u0019\u00111T\u0013\u0003\u000bMCwN\u001d;")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException e, long timeMs) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("tokens", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking remaining tokens in the token bucket per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = this.clientRateMetricName(metricTags);
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName = null;
        rate = null;
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    @Override
    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Quota violated for sensor (" + quotaSensor.name() + "). Delay time: (" + throttleTimeMs + ")");
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType.CONTROLLER_MUTATION, time, threadNamePrefix, quotaCallback);
    }
}

