/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class TimeWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private Long windowSize;
    private boolean isChangelogTopic;
    private Deserializer<T> inner;

    public TimeWindowedDeserializer() {
        this(null, null);
    }

    public TimeWindowedDeserializer(Deserializer<T> inner, Long windowSize) {
        this.inner = inner;
        this.windowSize = windowSize;
        this.isChangelogTopic = false;
    }

    public Long getWindowSize() {
        return this.windowSize;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Long configWindowSize = configs.get("window.size.ms") instanceof String ? Long.valueOf(Long.parseLong((String)configs.get("window.size.ms"))) : (Long)configs.get("window.size.ms");
        if (this.windowSize != null && configWindowSize != null) {
            throw new IllegalArgumentException("Window size should not be set in both the time windowed deserializer constructor and the window.size.ms config");
        }
        if (this.windowSize == null && configWindowSize == null) {
            throw new IllegalArgumentException("Window size needs to be set either through the time windowed deserializer constructor or the window.size.ms config but not both");
        }
        this.windowSize = this.windowSize == null ? configWindowSize : this.windowSize;
        String windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde");
        Serde windowInnerClassSerde = null;
        if (windowedInnerClassSerdeConfig != null) {
            try {
                windowInnerClassSerde = (Serde)Utils.newInstance((String)windowedInnerClassSerdeConfig, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException("windowed.inner.class.serde", (Object)windowedInnerClassSerdeConfig, "Serde class " + windowedInnerClassSerdeConfig + " could not be found.");
            }
        }
        if (this.inner != null && windowedInnerClassSerdeConfig != null) {
            if (!this.inner.getClass().getName().equals(windowInnerClassSerde.deserializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class deserializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in windowed.inner.class.serde config (" + windowInnerClassSerde.deserializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && windowedInnerClassSerdeConfig == null) {
                throw new IllegalArgumentException("Inner class deserializer should be set either via  constructor or via the windowed.inner.class.serde config");
            }
            if (this.inner == null) {
                this.inner = windowInnerClassSerde.deserializer();
            }
        }
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        WindowedSerdes.verifyInnerDeserializerNotNull(this.inner, this);
        if (data == null || data.length == 0) {
            return null;
        }
        if (this.isChangelogTopic) {
            return WindowKeySchema.fromStoreKey(data, this.windowSize, this.inner, topic);
        }
        return WindowKeySchema.from(data, this.windowSize, this.inner, topic);
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    public void setIsChangelogTopic(boolean isChangelogTopic) {
        this.isChangelogTopic = isChangelogTopic;
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

