/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.digest.BaseDigest;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.util.GenericUtils;

public enum BuiltinDigests implements DigestFactory
{
    md5("md5", "MD5", 16),
    sha1("sha1", "SHA-1", 20),
    sha224("sha224", "SHA-224", 28),
    sha256("sha256", "SHA-256", 32),
    sha384("sha384", "SHA-384", 48),
    sha512("sha512", "SHA-512", 64);

    public static final Set<BuiltinDigests> VALUES;
    private final String algorithm;
    private final int blockSize;
    private final String factoryName;
    private final boolean supported;

    private BuiltinDigests(String factoryName, String algorithm, int blockSize) {
        this.factoryName = factoryName;
        this.algorithm = algorithm;
        this.blockSize = blockSize;
        this.supported = DigestUtils.checkSupported(algorithm);
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getBlockSize() {
        return this.blockSize;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final Digest create() {
        return new BaseDigest(this.getAlgorithm(), this.getBlockSize());
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    public static BuiltinDigests fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinDigests c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinDigests fromFactory(NamedFactory<? extends Digest> factory) {
        if (factory == null) {
            return null;
        }
        return BuiltinDigests.fromFactoryName(factory.getName());
    }

    public static BuiltinDigests fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinDigests fromDigest(Digest d) {
        return BuiltinDigests.fromAlgorithm(d == null ? null : d.getAlgorithm());
    }

    public static BuiltinDigests fromAlgorithm(String algo) {
        return DigestUtils.findFactoryByAlgorithm(algo, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDigests.class));
    }

    public static final class Constants {
        public static final String MD5 = "md5";
        public static final String SHA1 = "sha1";
        public static final String SHA224 = "sha224";
        public static final String SHA256 = "sha256";
        public static final String SHA384 = "sha384";
        public static final String SHA512 = "sha512";
    }
}

