/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.internal.log.Arguments;
import org.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LoggerConsumer;
import org.osgi.service.log.admin.LoggerContext;

public class LoggerImpl
implements Logger {
    static final String THIS_PACKAGE_NAME = LoggerImpl.class.getName().substring(0, LoggerImpl.class.getName().length() - LoggerImpl.class.getSimpleName().length());
    static final Object[] EMPTY = new Object[0];
    protected final ExtendedLogServiceImpl logServiceImpl;
    protected final String name;
    private LogLevel enabledLevel = LogLevel.TRACE;
    private static final Pattern pattern = Pattern.compile("(\\\\?)(\\\\?)(\\{\\})");

    public LoggerImpl(ExtendedLogServiceImpl logServiceImpl, String name, LoggerContext loggerContext) {
        this.logServiceImpl = logServiceImpl;
        this.name = name;
        this.applyLoggerContext(loggerContext);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLoggable(int level) {
        return this.logServiceImpl.isLoggable(this.name, level);
    }

    @Override
    public void log(int level, String message) {
        this.log((ServiceReference)null, level, message, (Throwable)null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.log((ServiceReference)null, level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, null, level, message, sr, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(sr, null, level, message, sr, exception);
    }

    @Override
    public void log(Object context, int level, String message) {
        this.log(context, level, message, null);
    }

    @Override
    public void log(Object context, int level, String message, Throwable exception) {
        this.log(context, null, level, message, null, exception);
    }

    private void log(Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        this.log(this.logServiceImpl.getBundle(), context, logLevelEnum, level, message, ref, exception);
    }

    void log(Bundle entryBundle, Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        if (logLevelEnum == null) {
            logLevelEnum = this.getLogLevel(level);
        }
        if (this.enabledLevel.implies(logLevelEnum)) {
            this.logServiceImpl.getFactory().log(entryBundle, this.name, this.getLocation(), context, logLevelEnum, level, message, ref, exception);
        }
    }

    private LogLevel getLogLevel(int level) {
        switch (level) {
            case 4: {
                return LogLevel.DEBUG;
            }
            case 1: {
                return LogLevel.ERROR;
            }
            case 3: {
                return LogLevel.INFO;
            }
            case 2: {
                return LogLevel.WARN;
            }
        }
        return LogLevel.TRACE;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.enabledLevel.implies(LogLevel.TRACE);
    }

    @Override
    public void trace(String message) {
        this.trace(message, EMPTY);
    }

    @Override
    public void trace(String format, Object arg) {
        this.trace(format, new Object[]{arg});
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.trace(format, new Object[]{arg1, arg2});
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(LogLevel.TRACE, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.enabledLevel.implies(LogLevel.DEBUG);
    }

    @Override
    public void debug(String message) {
        this.debug(message, EMPTY);
    }

    @Override
    public void debug(String format, Object arg) {
        this.debug(format, new Object[]{arg});
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.debug(format, new Object[]{arg1, arg2});
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(LogLevel.DEBUG, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.enabledLevel.implies(LogLevel.INFO);
    }

    @Override
    public void info(String message) {
        this.info(message, EMPTY);
    }

    @Override
    public void info(String format, Object arg) {
        this.info(format, new Object[]{arg});
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.info(format, new Object[]{arg1, arg2});
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(LogLevel.INFO, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.enabledLevel.implies(LogLevel.WARN);
    }

    @Override
    public void warn(String message) {
        this.warn(message, EMPTY);
    }

    @Override
    public void warn(String format, Object arg) {
        this.warn(format, new Object[]{arg});
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.warn(format, new Object[]{arg1, arg2});
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(LogLevel.WARN, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.enabledLevel.implies(LogLevel.ERROR);
    }

    @Override
    public void error(String message) {
        this.error(message, EMPTY);
    }

    @Override
    public void error(String format, Object arg) {
        this.error(format, new Object[]{arg});
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.error(format, new Object[]{arg1, arg2});
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(LogLevel.ERROR, format, arguments);
    }

    @Override
    public void audit(String message) {
        this.audit(message, EMPTY);
    }

    @Override
    public void audit(String format, Object arg) {
        this.audit(format, new Object[]{arg});
    }

    @Override
    public void audit(String format, Object arg1, Object arg2) {
        this.audit(format, new Object[]{arg1, arg2});
    }

    @Override
    public void audit(String format, Object ... arguments) {
        this.log(LogLevel.AUDIT, format, arguments);
    }

    @Override
    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept(this);
        }
    }

    private void log(LogLevel level, String format, Object ... arguments) {
        if (!this.enabledLevel.implies(level)) {
            return;
        }
        StackTraceElement location = this.getLocation();
        Arguments processedArguments = new Arguments(arguments);
        String message = processedArguments.isEmpty() ? format : this.formatMessage(format, processedArguments);
        this.logServiceImpl.getFactory().log(this.logServiceImpl.getBundle(), this.name, location, processedArguments.serviceReference(), level, level.ordinal(), message.toString(), processedArguments.serviceReference(), processedArguments.throwable());
    }

    private StackTraceElement getLocation() {
        if (!this.logServiceImpl.getFactory().captureLogEntryLocation()) {
            return null;
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length == 0) {
            return null;
        }
        int i = 1;
        while (i < elements.length) {
            if (!elements[i].getClassName().startsWith(THIS_PACKAGE_NAME)) {
                return elements[i];
            }
            ++i;
        }
        return elements[1];
    }

    String formatMessage(String format, Arguments processedArguments) {
        Matcher matcher = pattern.matcher(format);
        char[] chars = format.toCharArray();
        int offset = 0;
        StringBuilder message = new StringBuilder(format.length() * 2);
        Object[] objectArray = processedArguments.arguments();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            while (matcher.find()) {
                if (matcher.group(2).isEmpty()) {
                    if (matcher.group(1).isEmpty()) {
                        offset = LoggerImpl.append(message, matcher, chars, offset, matcher.start(3) - offset, argument);
                        break;
                    }
                    offset = LoggerImpl.append(message, matcher, chars, offset, matcher.start(3) - offset - 1, matcher.group(3));
                    continue;
                }
                offset = LoggerImpl.append(message, matcher, chars, offset, matcher.start(3) - offset - 1, argument);
                break;
            }
            ++n2;
        }
        message.append(chars, offset, chars.length - offset);
        return message.toString();
    }

    private static int append(StringBuilder builder, Matcher matcher, char[] chars, int offset, int length, Object argument) {
        builder.append(chars, offset, length);
        builder.append(argument);
        return matcher.end(3);
    }

    void applyLoggerContext(LoggerContext loggerContext) {
        this.enabledLevel = loggerContext == null ? LogLevel.WARN : loggerContext.getEffectiveLogLevel(this.name);
    }
}

