/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.LocalCamelController;
import org.apache.camel.commands.internal.RegexUtil;

public abstract class AbstractRouteCommand
extends AbstractCamelCommand {
    private String route;
    private String context;

    protected AbstractRouteCommand(String route, String context) {
        this.route = route;
        this.context = context;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> camelRoutes = camelController.getRoutes(this.context, RegexUtil.wildcardAsRegex(this.route));
        if (camelRoutes == null || camelRoutes.isEmpty()) {
            err.println("Camel routes using " + this.route + " not found.");
            return null;
        }
        Collections.sort(camelRoutes, new RouteComparator());
        for (Map<String, String> row : camelRoutes) {
            String camelContextName = row.get("camelContextName");
            String routeId = row.get("routeId");
            if (camelController instanceof LocalCamelController) {
                this.executeLocal((LocalCamelController)camelController, camelContextName, routeId, out, err);
                continue;
            }
            this.executeOnRoute(camelController, camelContextName, routeId, out, err);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocal(LocalCamelController camelController, String camelContextName, String routeId, PrintStream out, PrintStream err) throws Exception {
        CamelContext camelContext = camelController.getLocalCamelContext(this.context);
        if (camelContext == null) {
            err.println("Camel context " + this.context + " not found.");
            return;
        }
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader applicationContextClassLoader = camelContext.getApplicationContextClassLoader();
        if (applicationContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(applicationContextClassLoader);
        }
        try {
            this.executeOnRoute(camelController, camelContextName, routeId, out, err);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    public abstract void executeOnRoute(CamelController var1, String var2, String var3, PrintStream var4, PrintStream var5) throws Exception;

    private static final class RouteComparator
    implements Comparator<Map<String, String>> {
        private RouteComparator() {
        }

        @Override
        public int compare(Map<String, String> route1, Map<String, String> route2) {
            String camel2;
            String camel1 = route1.get("camelContextName");
            if (camel1.equals(camel2 = route2.get("camelContextName"))) {
                return route1.get("routeId").compareTo(route2.get("routeId"));
            }
            return camel1.compareTo(camel2);
        }
    }
}

