/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.supplier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import shaded.org.apache.maven.model.building.ModelBuilder;
import shaded.org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import shaded.org.apache.maven.repository.internal.DefaultModelCacheFactory;
import shaded.org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import shaded.org.apache.maven.repository.internal.DefaultVersionResolver;
import shaded.org.apache.maven.repository.internal.ModelCacheFactory;
import shaded.org.apache.maven.repository.internal.PluginsMetadataGeneratorFactory;
import shaded.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import shaded.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import shaded.org.eclipse.aether.RepositoryListener;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.impl.ArtifactDescriptorReader;
import shaded.org.eclipse.aether.impl.ArtifactResolver;
import shaded.org.eclipse.aether.impl.DependencyCollector;
import shaded.org.eclipse.aether.impl.Deployer;
import shaded.org.eclipse.aether.impl.Installer;
import shaded.org.eclipse.aether.impl.LocalRepositoryProvider;
import shaded.org.eclipse.aether.impl.MetadataGeneratorFactory;
import shaded.org.eclipse.aether.impl.MetadataResolver;
import shaded.org.eclipse.aether.impl.OfflineController;
import shaded.org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import shaded.org.eclipse.aether.impl.RepositoryConnectorProvider;
import shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import shaded.org.eclipse.aether.impl.RepositorySystemLifecycle;
import shaded.org.eclipse.aether.impl.UpdateCheckManager;
import shaded.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import shaded.org.eclipse.aether.impl.VersionRangeResolver;
import shaded.org.eclipse.aether.impl.VersionResolver;
import shaded.org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import shaded.org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import shaded.org.eclipse.aether.internal.impl.DefaultDeployer;
import shaded.org.eclipse.aether.internal.impl.DefaultFileProcessor;
import shaded.org.eclipse.aether.internal.impl.DefaultInstaller;
import shaded.org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import shaded.org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import shaded.org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import shaded.org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import shaded.org.eclipse.aether.internal.impl.DefaultOfflineController;
import shaded.org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import shaded.org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import shaded.org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import shaded.org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import shaded.org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import shaded.org.eclipse.aether.internal.impl.DefaultRepositorySystemLifecycle;
import shaded.org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import shaded.org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import shaded.org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import shaded.org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import shaded.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.internal.impl.LocalPathComposer;
import shaded.org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import shaded.org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import shaded.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.internal.impl.TrackingFileManager;
import shaded.org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import shaded.org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.internal.impl.checksum.SparseDirectoryTrustedChecksumsSource;
import shaded.org.eclipse.aether.internal.impl.checksum.SummaryFileTrustedChecksumsSource;
import shaded.org.eclipse.aether.internal.impl.checksum.TrustedToProvidedChecksumsSourceAdapter;
import shaded.org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import shaded.org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import shaded.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import shaded.org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import shaded.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager;
import shaded.org.eclipse.aether.internal.impl.filter.GroupIdRemoteRepositoryFilterSource;
import shaded.org.eclipse.aether.internal.impl.filter.PrefixesRemoteRepositoryFilterSource;
import shaded.org.eclipse.aether.internal.impl.resolution.TrustedChecksumsArtifactResolverPostProcessor;
import shaded.org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMappers;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactoryImpl;
import shaded.org.eclipse.aether.named.NamedLockFactory;
import shaded.org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.NoopNamedLockFactory;
import shaded.org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import shaded.org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import shaded.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import shaded.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import shaded.org.eclipse.aether.spi.io.FileProcessor;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import shaded.org.eclipse.aether.spi.synccontext.SyncContextFactory;
import shaded.org.eclipse.aether.transport.file.FileTransporterFactory;
import shaded.org.eclipse.aether.transport.http.ChecksumExtractor;
import shaded.org.eclipse.aether.transport.http.HttpTransporterFactory;
import shaded.org.eclipse.aether.transport.http.Nexus2ChecksumExtractor;
import shaded.org.eclipse.aether.transport.http.XChecksumChecksumExtractor;

public class RepositorySystemSupplier
implements Supplier<RepositorySystem> {
    protected FileProcessor getFileProcessor() {
        return new DefaultFileProcessor();
    }

    protected TrackingFileManager getTrackingFileManager() {
        return new DefaultTrackingFileManager();
    }

    protected LocalPathComposer getLocalPathComposer() {
        return new DefaultLocalPathComposer();
    }

    protected LocalPathPrefixComposerFactory getLocalPathPrefixComposerFactory() {
        return new DefaultLocalPathPrefixComposerFactory();
    }

    protected RepositorySystemLifecycle getRepositorySystemLifecycle() {
        return new DefaultRepositorySystemLifecycle();
    }

    protected OfflineController getOfflineController() {
        return new DefaultOfflineController();
    }

    protected UpdatePolicyAnalyzer getUpdatePolicyAnalyzer() {
        return new DefaultUpdatePolicyAnalyzer();
    }

    protected ChecksumPolicyProvider getChecksumPolicyProvider() {
        return new DefaultChecksumPolicyProvider();
    }

    protected UpdateCheckManager getUpdateCheckManager(TrackingFileManager trackingFileManager, UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        return new DefaultUpdateCheckManager(trackingFileManager, updatePolicyAnalyzer);
    }

    protected Map<String, NamedLockFactory> getNamedLockFactories() {
        HashMap<String, NamedLockFactory> result = new HashMap<String, NamedLockFactory>();
        result.put("noop", new NoopNamedLockFactory());
        result.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        result.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        result.put("file-lock", new FileLockNamedLockFactory());
        return result;
    }

    protected Map<String, NameMapper> getNameMappers() {
        HashMap<String, NameMapper> result = new HashMap<String, NameMapper>();
        result.put("static", NameMappers.staticNameMapper());
        result.put("gav", NameMappers.gavNameMapper());
        result.put("gaecv", NameMappers.gaecvNameMapper());
        result.put("discriminating", NameMappers.discriminatingNameMapper());
        result.put("file-gav", NameMappers.fileGavNameMapper());
        result.put("file-gaecv", NameMappers.fileGaecvNameMapper());
        result.put("file-hgav", NameMappers.fileHashingGavNameMapper());
        result.put("file-hgaecv", NameMappers.fileHashingGaecvNameMapper());
        return result;
    }

    protected NamedLockFactoryAdapterFactory getNamedLockFactoryAdapterFactory(Map<String, NamedLockFactory> namedLockFactories, Map<String, NameMapper> nameMappers, RepositorySystemLifecycle repositorySystemLifecycle) {
        return new NamedLockFactoryAdapterFactoryImpl(namedLockFactories, nameMappers, repositorySystemLifecycle);
    }

    protected SyncContextFactory getSyncContextFactory(NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory) {
        return new DefaultSyncContextFactory(namedLockFactoryAdapterFactory);
    }

    protected Map<String, ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        HashMap<String, ChecksumAlgorithmFactory> result = new HashMap<String, ChecksumAlgorithmFactory>();
        result.put("SHA-512", new Sha512ChecksumAlgorithmFactory());
        result.put("SHA-256", new Sha256ChecksumAlgorithmFactory());
        result.put("SHA-1", new Sha1ChecksumAlgorithmFactory());
        result.put("MD5", new Md5ChecksumAlgorithmFactory());
        return result;
    }

    protected ChecksumAlgorithmFactorySelector getChecksumAlgorithmFactorySelector(Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        return new DefaultChecksumAlgorithmFactorySelector(checksumAlgorithmFactories);
    }

    protected Map<String, RepositoryLayoutFactory> getRepositoryLayoutFactories(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        HashMap<String, RepositoryLayoutFactory> result = new HashMap<String, RepositoryLayoutFactory>();
        result.put("maven2", new Maven2RepositoryLayoutFactory(checksumAlgorithmFactorySelector));
        return result;
    }

    protected RepositoryLayoutProvider getRepositoryLayoutProvider(Map<String, RepositoryLayoutFactory> repositoryLayoutFactories) {
        return new DefaultRepositoryLayoutProvider(new HashSet<RepositoryLayoutFactory>(repositoryLayoutFactories.values()));
    }

    protected LocalRepositoryProvider getLocalRepositoryProvider(LocalPathComposer localPathComposer, TrackingFileManager trackingFileManager, LocalPathPrefixComposerFactory localPathPrefixComposerFactory) {
        HashSet<LocalRepositoryManagerFactory> localRepositoryProviders = new HashSet<LocalRepositoryManagerFactory>(2);
        localRepositoryProviders.add(new SimpleLocalRepositoryManagerFactory(localPathComposer));
        localRepositoryProviders.add(new EnhancedLocalRepositoryManagerFactory(localPathComposer, trackingFileManager, localPathPrefixComposerFactory));
        return new DefaultLocalRepositoryProvider(localRepositoryProviders);
    }

    protected RemoteRepositoryManager getRemoteRepositoryManager(UpdatePolicyAnalyzer updatePolicyAnalyzer, ChecksumPolicyProvider checksumPolicyProvider) {
        return new DefaultRemoteRepositoryManager(updatePolicyAnalyzer, checksumPolicyProvider);
    }

    protected Map<String, RemoteRepositoryFilterSource> getRemoteRepositoryFilterSources(RepositorySystemLifecycle repositorySystemLifecycle, RepositoryLayoutProvider repositoryLayoutProvider) {
        HashMap<String, RemoteRepositoryFilterSource> result = new HashMap<String, RemoteRepositoryFilterSource>();
        result.put("groupId", new GroupIdRemoteRepositoryFilterSource(repositorySystemLifecycle));
        result.put("prefixes", new PrefixesRemoteRepositoryFilterSource(repositoryLayoutProvider));
        return result;
    }

    protected RemoteRepositoryFilterManager getRemoteRepositoryFilterManager(Map<String, RemoteRepositoryFilterSource> remoteRepositoryFilterSources) {
        return new DefaultRemoteRepositoryFilterManager(remoteRepositoryFilterSources);
    }

    protected Map<String, RepositoryListener> getRepositoryListeners() {
        return new HashMap<String, RepositoryListener>();
    }

    protected RepositoryEventDispatcher getRepositoryEventDispatcher(Map<String, RepositoryListener> repositoryListeners) {
        return new DefaultRepositoryEventDispatcher(new HashSet<RepositoryListener>(repositoryListeners.values()));
    }

    protected Map<String, TrustedChecksumsSource> getTrustedChecksumsSources(FileProcessor fileProcessor, LocalPathComposer localPathComposer, RepositorySystemLifecycle repositorySystemLifecycle) {
        HashMap<String, TrustedChecksumsSource> result = new HashMap<String, TrustedChecksumsSource>();
        result.put("sparseDirectory", new SparseDirectoryTrustedChecksumsSource(fileProcessor, localPathComposer));
        result.put("summaryFile", new SummaryFileTrustedChecksumsSource(localPathComposer, repositorySystemLifecycle));
        return result;
    }

    protected Map<String, ProvidedChecksumsSource> getProvidedChecksumsSources(Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        HashMap<String, ProvidedChecksumsSource> result = new HashMap<String, ProvidedChecksumsSource>();
        result.put("trusted2provided", new TrustedToProvidedChecksumsSourceAdapter(trustedChecksumsSources));
        return result;
    }

    protected Map<String, ChecksumExtractor> getChecksumExtractors() {
        HashMap<String, ChecksumExtractor> result = new HashMap<String, ChecksumExtractor>();
        result.put("nexus2", new Nexus2ChecksumExtractor());
        result.put("x-checksum", new XChecksumChecksumExtractor());
        return result;
    }

    protected Map<String, TransporterFactory> getTransporterFactories(Map<String, ChecksumExtractor> extractors) {
        HashMap<String, TransporterFactory> result = new HashMap<String, TransporterFactory>();
        result.put("file", new FileTransporterFactory());
        result.put("http", new HttpTransporterFactory(extractors));
        return result;
    }

    protected TransporterProvider getTransporterProvider(Map<String, TransporterFactory> transporterFactories) {
        return new DefaultTransporterProvider(new HashSet<TransporterFactory>(transporterFactories.values()));
    }

    protected BasicRepositoryConnectorFactory getBasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider repositoryLayoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        return new BasicRepositoryConnectorFactory(transporterProvider, repositoryLayoutProvider, checksumPolicyProvider, fileProcessor, providedChecksumsSources);
    }

    protected Map<String, RepositoryConnectorFactory> getRepositoryConnectorFactories(BasicRepositoryConnectorFactory basicRepositoryConnectorFactory) {
        HashMap<String, RepositoryConnectorFactory> result = new HashMap<String, RepositoryConnectorFactory>();
        result.put("basic", basicRepositoryConnectorFactory);
        return result;
    }

    protected RepositoryConnectorProvider getRepositoryConnectorProvider(Map<String, RepositoryConnectorFactory> repositoryConnectorFactories, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultRepositoryConnectorProvider(new HashSet<RepositoryConnectorFactory>(repositoryConnectorFactories.values()), remoteRepositoryFilterManager);
    }

    protected Installer getInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Map<String, MetadataGeneratorFactory> metadataGeneratorFactories, SyncContextFactory syncContextFactory) {
        return new DefaultInstaller(fileProcessor, repositoryEventDispatcher, new HashSet<MetadataGeneratorFactory>(metadataGeneratorFactories.values()), syncContextFactory);
    }

    protected Deployer getDeployer(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, UpdateCheckManager updateCheckManager, Map<String, MetadataGeneratorFactory> metadataGeneratorFactories, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        return new DefaultDeployer(fileProcessor, repositoryEventDispatcher, repositoryConnectorProvider, remoteRepositoryManager, updateCheckManager, new HashSet<MetadataGeneratorFactory>(metadataGeneratorFactories.values()), syncContextFactory, offlineController);
    }

    protected Map<String, DependencyCollectorDelegate> getDependencyCollectorDelegates(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        HashMap<String, DependencyCollectorDelegate> result = new HashMap<String, DependencyCollectorDelegate>();
        result.put("df", new DfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        result.put("bf", new BfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        return result;
    }

    protected DependencyCollector getDependencyCollector(Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates) {
        return new DefaultDependencyCollector(dependencyCollectorDelegates);
    }

    protected Map<String, ArtifactResolverPostProcessor> getArtifactResolverPostProcessors(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        HashMap<String, ArtifactResolverPostProcessor> result = new HashMap<String, ArtifactResolverPostProcessor>();
        result.put("trustedChecksums", new TrustedChecksumsArtifactResolverPostProcessor(checksumAlgorithmFactorySelector, trustedChecksumsSources));
        return result;
    }

    protected ArtifactResolver getArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultArtifactResolver(fileProcessor, repositoryEventDispatcher, versionResolver, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, artifactResolverPostProcessors, remoteRepositoryFilterManager);
    }

    protected MetadataResolver getMetadataResolver(RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        return new DefaultMetadataResolver(repositoryEventDispatcher, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, remoteRepositoryFilterManager);
    }

    protected Map<String, MetadataGeneratorFactory> getMetadataGeneratorFactories() {
        HashMap<String, MetadataGeneratorFactory> result = new HashMap<String, MetadataGeneratorFactory>();
        result.put("plugins", new PluginsMetadataGeneratorFactory());
        result.put("versions", new VersionsMetadataGeneratorFactory());
        result.put("snapshot", new SnapshotMetadataGeneratorFactory());
        return result;
    }

    protected ArtifactDescriptorReader getArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, ModelCacheFactory modelCacheFactory) {
        DefaultArtifactDescriptorReader result = new DefaultArtifactDescriptorReader();
        result.setRemoteRepositoryManager(remoteRepositoryManager);
        result.setVersionResolver(versionResolver);
        result.setVersionRangeResolver(versionRangeResolver);
        result.setArtifactResolver(artifactResolver);
        result.setModelBuilder(modelBuilder);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        result.setModelCacheFactory(modelCacheFactory);
        return result;
    }

    protected VersionResolver getVersionResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        DefaultVersionResolver result = new DefaultVersionResolver();
        result.setMetadataResolver(metadataResolver);
        result.setSyncContextFactory(syncContextFactory);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        return result;
    }

    protected VersionRangeResolver getVersionRangeResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        DefaultVersionRangeResolver result = new DefaultVersionRangeResolver();
        result.setMetadataResolver(metadataResolver);
        result.setSyncContextFactory(syncContextFactory);
        result.setRepositoryEventDispatcher(repositoryEventDispatcher);
        return result;
    }

    protected ModelBuilder getModelBuilder() {
        return new DefaultModelBuilderFactory().newInstance();
    }

    protected ModelCacheFactory getModelCacheFactory() {
        return new DefaultModelCacheFactory();
    }

    @Override
    public RepositorySystem get() {
        FileProcessor fileProcessor = this.getFileProcessor();
        TrackingFileManager trackingFileManager = this.getTrackingFileManager();
        LocalPathComposer localPathComposer = this.getLocalPathComposer();
        LocalPathPrefixComposerFactory localPathPrefixComposerFactory = this.getLocalPathPrefixComposerFactory();
        RepositorySystemLifecycle repositorySystemLifecycle = this.getRepositorySystemLifecycle();
        OfflineController offlineController = this.getOfflineController();
        UpdatePolicyAnalyzer updatePolicyAnalyzer = this.getUpdatePolicyAnalyzer();
        ChecksumPolicyProvider checksumPolicyProvider = this.getChecksumPolicyProvider();
        UpdateCheckManager updateCheckManager = this.getUpdateCheckManager(trackingFileManager, updatePolicyAnalyzer);
        Map<String, NamedLockFactory> namedLockFactories = this.getNamedLockFactories();
        Map<String, NameMapper> nameMappers = this.getNameMappers();
        NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory = this.getNamedLockFactoryAdapterFactory(namedLockFactories, nameMappers, repositorySystemLifecycle);
        SyncContextFactory syncContextFactory = this.getSyncContextFactory(namedLockFactoryAdapterFactory);
        Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories = this.getChecksumAlgorithmFactories();
        ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector = this.getChecksumAlgorithmFactorySelector(checksumAlgorithmFactories);
        Map<String, RepositoryLayoutFactory> repositoryLayoutFactories = this.getRepositoryLayoutFactories(checksumAlgorithmFactorySelector);
        RepositoryLayoutProvider repositoryLayoutProvider = this.getRepositoryLayoutProvider(repositoryLayoutFactories);
        LocalRepositoryProvider localRepositoryProvider = this.getLocalRepositoryProvider(localPathComposer, trackingFileManager, localPathPrefixComposerFactory);
        RemoteRepositoryManager remoteRepositoryManager = this.getRemoteRepositoryManager(updatePolicyAnalyzer, checksumPolicyProvider);
        Map<String, RemoteRepositoryFilterSource> remoteRepositoryFilterSources = this.getRemoteRepositoryFilterSources(repositorySystemLifecycle, repositoryLayoutProvider);
        RemoteRepositoryFilterManager remoteRepositoryFilterManager = this.getRemoteRepositoryFilterManager(remoteRepositoryFilterSources);
        Map<String, RepositoryListener> repositoryListeners = this.getRepositoryListeners();
        RepositoryEventDispatcher repositoryEventDispatcher = this.getRepositoryEventDispatcher(repositoryListeners);
        Map<String, TrustedChecksumsSource> trustedChecksumsSources = this.getTrustedChecksumsSources(fileProcessor, localPathComposer, repositorySystemLifecycle);
        Map<String, ProvidedChecksumsSource> providedChecksumsSources = this.getProvidedChecksumsSources(trustedChecksumsSources);
        Map<String, ChecksumExtractor> checksumExtractors = this.getChecksumExtractors();
        Map<String, TransporterFactory> transporterFactories = this.getTransporterFactories(checksumExtractors);
        TransporterProvider transporterProvider = this.getTransporterProvider(transporterFactories);
        BasicRepositoryConnectorFactory basic = this.getBasicRepositoryConnectorFactory(transporterProvider, repositoryLayoutProvider, checksumPolicyProvider, fileProcessor, providedChecksumsSources);
        Map<String, RepositoryConnectorFactory> repositoryConnectorFactories = this.getRepositoryConnectorFactories(basic);
        RepositoryConnectorProvider repositoryConnectorProvider = this.getRepositoryConnectorProvider(repositoryConnectorFactories, remoteRepositoryFilterManager);
        Map<String, MetadataGeneratorFactory> metadataGeneratorFactories = this.getMetadataGeneratorFactories();
        Installer installer = this.getInstaller(fileProcessor, repositoryEventDispatcher, metadataGeneratorFactories, syncContextFactory);
        Deployer deployer = this.getDeployer(fileProcessor, repositoryEventDispatcher, repositoryConnectorProvider, remoteRepositoryManager, updateCheckManager, metadataGeneratorFactories, syncContextFactory, offlineController);
        MetadataResolver metadataResolver = this.getMetadataResolver(repositoryEventDispatcher, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, remoteRepositoryFilterManager);
        VersionResolver versionResolver = this.getVersionResolver(metadataResolver, syncContextFactory, repositoryEventDispatcher);
        VersionRangeResolver versionRangeResolver = this.getVersionRangeResolver(metadataResolver, syncContextFactory, repositoryEventDispatcher);
        Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors = this.getArtifactResolverPostProcessors(checksumAlgorithmFactorySelector, trustedChecksumsSources);
        ArtifactResolver artifactResolver = this.getArtifactResolver(fileProcessor, repositoryEventDispatcher, versionResolver, updateCheckManager, repositoryConnectorProvider, remoteRepositoryManager, syncContextFactory, offlineController, artifactResolverPostProcessors, remoteRepositoryFilterManager);
        ModelBuilder modelBuilder = this.getModelBuilder();
        ModelCacheFactory modelCacheFactory = this.getModelCacheFactory();
        ArtifactDescriptorReader artifactDescriptorReader = this.getArtifactDescriptorReader(remoteRepositoryManager, versionResolver, versionRangeResolver, artifactResolver, modelBuilder, repositoryEventDispatcher, modelCacheFactory);
        Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates = this.getDependencyCollectorDelegates(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
        DependencyCollector dependencyCollector = this.getDependencyCollector(dependencyCollectorDelegates);
        return new DefaultRepositorySystem(versionResolver, versionRangeResolver, artifactResolver, metadataResolver, artifactDescriptorReader, dependencyCollector, installer, deployer, localRepositoryProvider, syncContextFactory, remoteRepositoryManager, repositorySystemLifecycle);
    }
}

