/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.directory.shared.kerberos.codec.EncKdcRepPart.EncKdcRepPartContainer;
import org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.directory.shared.kerberos.codec.apRep.ApRepContainer;
import org.apache.directory.shared.kerberos.codec.apReq.ApReqContainer;
import org.apache.directory.shared.kerberos.codec.authenticator.AuthenticatorContainer;
import org.apache.directory.shared.kerberos.codec.authorizationData.AuthorizationDataContainer;
import org.apache.directory.shared.kerberos.codec.encApRepPart.EncApRepPartContainer;
import org.apache.directory.shared.kerberos.codec.encAsRepPart.EncAsRepPartContainer;
import org.apache.directory.shared.kerberos.codec.encKrbPrivPart.EncKrbPrivPartContainer;
import org.apache.directory.shared.kerberos.codec.encTgsRepPart.EncTgsRepPartContainer;
import org.apache.directory.shared.kerberos.codec.encTicketPart.EncTicketPartContainer;
import org.apache.directory.shared.kerberos.codec.encryptedData.EncryptedDataContainer;
import org.apache.directory.shared.kerberos.codec.encryptionKey.EncryptionKeyContainer;
import org.apache.directory.shared.kerberos.codec.krbPriv.KrbPrivContainer;
import org.apache.directory.shared.kerberos.codec.paEncTsEnc.PaEncTsEncContainer;
import org.apache.directory.shared.kerberos.codec.principalName.PrincipalNameContainer;
import org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.apache.directory.shared.kerberos.components.EncTicketPart;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.PaEncTsEnc;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.ApRep;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.directory.shared.kerberos.messages.EncApRepPart;
import org.apache.directory.shared.kerberos.messages.EncAsRepPart;
import org.apache.directory.shared.kerberos.messages.EncTgsRepPart;
import org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDecoder {
    private static Logger LOG = LoggerFactory.getLogger(KerberosDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object decode(KerberosMessageContainer kerberosMessageContainer) throws DecoderException {
        ByteBuffer buf = kerberosMessageContainer.getStream();
        if (kerberosMessageContainer.isTCP()) {
            if (buf.remaining() <= 4) return null;
            kerberosMessageContainer.setTcpLength(buf.getInt());
            buf.mark();
        } else {
            buf.mark();
        }
        while (buf.hasRemaining()) {
            try {
                Asn1Decoder.decode((ByteBuffer)buf, (Asn1Container)kerberosMessageContainer);
                if (kerberosMessageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (!IS_DEBUG) return kerberosMessageContainer.getMessage();
                LOG.debug("Decoded KerberosMessage : {}", (Object)kerberosMessageContainer.getMessage());
                buf.mark();
                return kerberosMessageContainer.getMessage();
            }
            catch (DecoderException de) {
                LOG.warn("error while decoding", (Throwable)de);
                buf.clear();
                kerberosMessageContainer.clean();
                throw de;
            }
        }
        return null;
    }

    public static EncryptedData decodeEncryptedData(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncryptedDataContainer encryptedDataContainer = new EncryptedDataContainer();
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encryptedDataContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encryptedDataContainer.getEncryptedData();
    }

    public static PaEncTsEnc decodePaEncTsEnc(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        PaEncTsEncContainer paEncTsEncContainer = new PaEncTsEncContainer();
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)paEncTsEncContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return paEncTsEncContainer.getPaEncTsEnc();
    }

    public static EncApRepPart decodeEncApRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncApRepPartContainer encApRepPartContainer = new EncApRepPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encApRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encApRepPartContainer.getEncApRepPart();
    }

    public static EncKdcRepPart decodeEncKdcRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncKdcRepPartContainer encKdcRepPartContainer = new EncKdcRepPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encKdcRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encKdcRepPartContainer.getEncKdcRepPart();
    }

    public static EncKrbPrivPart decodeEncKrbPrivPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncKrbPrivPartContainer encKrbPrivPartContainer = new EncKrbPrivPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encKrbPrivPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encKrbPrivPartContainer.getEncKrbPrivPart();
    }

    public static EncTicketPart decodeEncTicketPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncTicketPartContainer encTicketPartContainer = new EncTicketPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encTicketPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encTicketPartContainer.getEncTicketPart();
    }

    public static EncryptionKey decodeEncryptionKey(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncryptionKeyContainer encryptionKeyContainer = new EncryptionKeyContainer();
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encryptionKeyContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encryptionKeyContainer.getEncryptionKey();
    }

    public static PrincipalName decodePrincipalName(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        PrincipalNameContainer principalNameContainer = new PrincipalNameContainer();
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)principalNameContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return principalNameContainer.getPrincipalName();
    }

    public static Ticket decodeTicket(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        TicketContainer ticketContainer = new TicketContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)ticketContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return ticketContainer.getTicket();
    }

    public static Authenticator decodeAuthenticator(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        AuthenticatorContainer authenticatorContainer = new AuthenticatorContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)authenticatorContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return authenticatorContainer.getAuthenticator();
    }

    public static AuthorizationData decodeAuthorizationData(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        AuthorizationDataContainer authorizationDataContainer = new AuthorizationDataContainer();
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)authorizationDataContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return authorizationDataContainer.getAuthorizationData();
    }

    public static ApRep decodeApRep(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        ApRepContainer apRepContainer = new ApRepContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)apRepContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return apRepContainer.getApRep();
    }

    public static ApReq decodeApReq(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        ApReqContainer apReqContainer = new ApReqContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)apReqContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return apReqContainer.getApReq();
    }

    public static KrbPriv decodeKrbPriv(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        KrbPrivContainer krbPrivContainer = new KrbPrivContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)krbPrivContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return krbPrivContainer.getKrbPriv();
    }

    public static EncAsRepPart decodeEncAsRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncAsRepPartContainer encAsRepPartContainer = new EncAsRepPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encAsRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encAsRepPartContainer.getEncAsRepPart();
    }

    public static EncTgsRepPart decodeEncTgsRepPart(byte[] data) throws ChangePasswordException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncTgsRepPartContainer encTgsRepPartContainer = new EncTgsRepPartContainer(stream);
        try {
            Asn1Decoder.decode((ByteBuffer)stream, (Asn1Container)encTgsRepPartContainer);
        }
        catch (DecoderException de) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_MALFORMED, (Throwable)de);
        }
        return encTgsRepPartContainer.getEncTgsRepPart();
    }
}

