/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleanListener
implements EventListenerRegistry.ResourceEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheCleanListener.class);

    public void onUpdate(KylinConfig config, RawResource rawResource) {
    }

    public void onDelete(KylinConfig config, String resPath) {
        try {
            Pair typeAndResourceName = MetadataType.splitKeyWithType((String)resPath);
            String resourceName = (String)typeAndResourceName.getSecond();
            switch ((MetadataType)typeAndResourceName.getFirst()) {
                case PROJECT: {
                    String project = resourceName;
                    if (!StringUtils.isNotBlank((CharSequence)project)) break;
                    NProjectManager.getInstance((KylinConfig)config).invalidCache(project);
                    break;
                }
                case TABLE_INFO: 
                case TABLE_EXD: {
                    String project = this.extractProject(resourceName);
                    if (!StringUtils.isNotBlank((CharSequence)project)) break;
                    NTableMetadataManager.getInstance((KylinConfig)config, (String)project).invalidCache(resourceName);
                    break;
                }
                case KAFKA_CONFIG: {
                    String project = this.extractProject(resourceName);
                    if (!StringUtils.isNotBlank((CharSequence)project)) break;
                    KafkaConfigManager.getInstance((KylinConfig)config, (String)project).invalidCache(resourceName);
                    break;
                }
                case INTERNAL_TABLE: {
                    String project = this.extractProject(resourceName);
                    if (!StringUtils.isNotBlank((CharSequence)project)) break;
                    InternalTableManager.getInstance((KylinConfig)config, (String)project).invalidCache(resourceName);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected error happened! Clean resource {} cache failed.", (Object)resPath, (Object)e);
        }
    }

    private String extractProject(String resourceName) {
        return resourceName.substring(0, resourceName.indexOf("."));
    }
}

