/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.rest.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@Order(value=-400)
public class V2ApiFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V2ApiFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest;
        if (request instanceof HttpServletRequest && "application/vnd.apache.kylin-v2+json".equalsIgnoreCase((servletRequest = (HttpServletRequest)request).getHeader("Accept"))) {
            String uri = servletRequest.getRequestURI();
            try {
                HandlerExecutionChain handler;
                HandlerMapping handlerMapping = this.getRequestMappingHandlerMapping(servletRequest);
                if (handlerMapping != null && (handler = handlerMapping.getHandler((HttpServletRequest)request)) == null) {
                    throw new NotFoundException(String.format(Locale.ROOT, "%s API of version v2 is no longer supported", uri));
                }
            }
            catch (Exception e) {
                log.warn("get handler from request uri {} failed", (Object)uri, (Object)e);
                throw new NotFoundException(String.format(Locale.ROOT, "%s API of version v2 is no longer supported", uri));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private HandlerMapping getRequestMappingHandlerMapping(HttpServletRequest request) {
        ServletContext servletContext = request.getSession().getServletContext();
        if (servletContext == null) {
            return null;
        }
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        Preconditions.checkNotNull((Object)appContext);
        Map allRequestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)appContext, HandlerMapping.class, (boolean)true, (boolean)false);
        return allRequestMappings.values().stream().filter(handlerMapping -> handlerMapping.getClass().equals(RequestMappingHandlerMapping.class)).findAny().orElse(null);
    }
}

