/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Optional;
import javax.naming.CommunicationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.rest.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component(value="nUnauthorisedEntryPoint")
public class NUnauthorisedEntryPoint
implements AuthenticationEntryPoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NUnauthorisedEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, org.springframework.security.core.AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof LockedException) {
            HttpUtil.setErrorResponse(request, response, 400, (Exception)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_LOCKED, exception.getMessage()));
            return;
        }
        if (exception instanceof InsufficientAuthenticationException) {
            HttpUtil.setErrorResponse(request, response, 401, (Exception)new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_UNAUTHORIZED, new Object[0]));
            this.logRequest(request);
            return;
        }
        if (exception instanceof DisabledException) {
            HttpUtil.setErrorResponse(request, response, 401, (Exception)new KylinException((ErrorCodeSupplier)ServerErrorCode.LOGIN_FAILED, MsgPicker.getMsg().getDisabledUser()));
            this.logRequest(request);
            return;
        }
        boolean present = Optional.ofNullable(exception).map(Throwable::getCause).filter(org.springframework.ldap.CommunicationException.class::isInstance).map(Throwable::getCause).filter(CommunicationException.class::isInstance).map(Throwable::getCause).filter(ConnectException.class::isInstance).isPresent();
        if (present) {
            HttpUtil.setErrorResponse(request, response, 500, (Exception)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_DATA_SOURCE_CONNECTION_FAILED, MsgPicker.getMsg().getlDapUserDataSourceConnectionFailed()));
            return;
        }
        present = Optional.ofNullable(exception).map(Throwable::getCause).filter(AuthenticationException.class::isInstance).map(Throwable::getCause).filter(javax.naming.AuthenticationException.class::isInstance).isPresent();
        if (present) {
            HttpUtil.setErrorResponse(request, response, 500, (Exception)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_DATA_SOURCE_CONNECTION_FAILED, MsgPicker.getMsg().getLdapUserDataSourceConfigError()));
            return;
        }
        HttpUtil.setErrorResponse(request, response, 401, (Exception)new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_LOGIN_FAILED, new Object[0]));
    }

    private void logRequest(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("Detail http request for authentication:\n" + HttpUtil.formatRequest(request));
        }
    }
}

