/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryDAO;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistoryRequest;
import org.apache.kylin.metadata.query.QueryHistorySql;
import org.apache.kylin.metadata.query.util.QueryHistoryUtil;
import org.apache.kylin.rest.service.AsyncTaskQueryHistorySupporter;
import org.apache.kylin.rest.service.AsyncTaskServiceSupporter;
import org.apache.kylin.tool.garbage.CleanTaskExecutorService;
import org.apache.kylin.tool.garbage.StorageCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service
public class AsyncTaskService
implements AsyncTaskServiceSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskService.class);
    private static final String GLOBAL = "global";

    @Override
    @Async
    public void cleanupStorage() throws Exception {
        long startAt = System.currentTimeMillis();
        try {
            CleanTaskExecutorService.getInstance().submit(new StorageCleaner().withTag(StorageCleaner.CleanerTag.SERVICE), KylinConfig.getInstanceFromEnv().getStorageCleanTaskTimeout(), TimeUnit.MILLISECONDS).get();
        }
        catch (Exception e) {
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.STORAGE_CLEAN_FAILED, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
            throw e;
        }
        finally {
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.STORAGE_CLEAN, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.STORAGE_CLEAN_DURATION, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (long)(System.currentTimeMillis() - startAt));
        }
    }

    @Override
    @Async
    public Future<Long> runDownloadQueryHistory(QueryHistoryRequest request, HttpServletResponse response, ZoneOffset zoneOffset, Integer timeZoneOffsetHour, QueryHistoryDAO queryHistoryDao, boolean onlySql) {
        long start = System.currentTimeMillis();
        try (ServletOutputStream ops = response.getOutputStream();){
            if (!onlySql) {
                ops.write(AsyncTaskQueryHistorySupporter.CSV_UTF8_BOM);
                ops.write(MsgPicker.getMsg().getQueryHistoryColumnMeta().getBytes(StandardCharsets.UTF_8));
            }
            this.batchDownload(request, zoneOffset, timeZoneOffsetHour, queryHistoryDao, onlySql, ops);
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, e.getMessage());
        }
        return new AsyncResult((Object)((System.currentTimeMillis() - start) / 1000L));
    }

    private void batchDownload(QueryHistoryRequest request, ZoneOffset zoneOffset, Integer timeZoneOffsetHour, QueryHistoryDAO queryHistoryDao, boolean onlySql, ServletOutputStream outputStream) throws IOException {
        List queryHistories;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        int needDownload = Math.min((int)queryHistoryDao.getQueryHistoriesSize(request, request.getProject()), kylinConfig.getQueryHistoryDownloadMaxSize());
        for (int hadDownload = 0; hadDownload < needDownload; hadDownload += queryHistories.size()) {
            int batchSize = Math.min(kylinConfig.getQueryHistoryDownloadBatchSize(), needDownload - hadDownload);
            queryHistories = queryHistoryDao.getQueryHistoriesByConditionsWithOffset(request, batchSize, hadDownload);
            for (QueryHistory queryHistory : queryHistories) {
                this.fillingModelAlias(kylinConfig, request.getProject(), queryHistory);
                if (onlySql) {
                    QueryHistorySql queryHistorySql = queryHistory.getQueryHistorySql();
                    String sql = queryHistorySql.getNormalizedSql();
                    outputStream.write((sql.replaceAll("\n|\r", " ") + ";\n").getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                outputStream.write((QueryHistoryUtil.getDownloadData((QueryHistory)queryHistory, (ZoneOffset)zoneOffset, (int)timeZoneOffsetHour) + "\n").getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private void fillingModelAlias(KylinConfig kylinConfig, String project, QueryHistory qh) {
        if (this.isQueryHistoryInfoEmpty(qh)) {
            return;
        }
        Map<String, String> noBrokenModels = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).listUnderliningDataModels().stream().collect(Collectors.toMap(NDataModel::getAlias, RootPersistentEntity::getUuid));
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
        List realizations = qh.transformRealizations(project);
        realizations.forEach(realization -> {
            NDataModel nDataModel = dataModelManager.getDataModelDesc(realization.getModelId());
            if (noBrokenModels.containsValue(realization.getModelId())) {
                realization.setModelAlias(nDataModel.getFusionModelAlias());
            } else {
                String modelAlias = nDataModel == null ? "Deleted Model" : String.format(Locale.ROOT, "%s broken", nDataModel.getAlias());
                realization.setModelAlias(modelAlias);
            }
        });
        qh.setNativeQueryRealizations(realizations);
    }

    private boolean isQueryHistoryInfoEmpty(QueryHistory queryHistory) {
        QueryHistoryInfo qhInfo = queryHistory.getQueryHistoryInfo();
        return (qhInfo == null || qhInfo.getRealizationMetrics() == null || qhInfo.getRealizationMetrics().isEmpty()) && StringUtils.isEmpty((CharSequence)queryHistory.getQueryRealizations());
    }
}

