/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.task;

import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.rest.service.task.QueryHistoryMetaUpdateScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaUpdateJob
extends AbstractExecutable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaUpdateJob.class);

    public MetaUpdateJob() {
    }

    public MetaUpdateJob(Object notSetId) {
        super(notSetId);
    }

    public static DefaultExecutable create(JobFactory.JobBuildParams jobBuildParams) {
        DefaultExecutable job = new DefaultExecutable();
        MetaUpdateJob innerJob = new MetaUpdateJob();
        innerJob.setParam("parentId", job.getJobId());
        job.addTask((AbstractExecutable)innerJob);
        job.setJobType(jobBuildParams.getJobType());
        return job;
    }

    protected ExecuteResult doWork(JobContext context) throws ExecuteException {
        String project = this.getProject();
        QueryHistoryMetaUpdateScheduler scheduler = QueryHistoryMetaUpdateScheduler.getInstance();
        try {
            QueryHistoryMetaUpdateScheduler queryHistoryMetaUpdateScheduler = scheduler;
            queryHistoryMetaUpdateScheduler.getClass();
            scheduler.scheduleImmediately(new QueryHistoryMetaUpdateScheduler.QueryHistoryMetaUpdateRunner(queryHistoryMetaUpdateScheduler, project)).get();
        }
        catch (InterruptedException e) {
            log.warn("Meta update task is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new ExecuteException("Failed to update meta via QueryHistory", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Failed to update meta via QueryHistory", (Throwable)e);
            throw new ExecuteException("Failed to update meta via QueryHistory", (Throwable)e);
        }
        return ExecuteResult.createSucceed();
    }

    static class MetaUpdateJobFactory
    extends JobFactory {
        MetaUpdateJobFactory() {
        }

        protected DefaultExecutable create(JobFactory.JobBuildParams jobBuildParams) {
            return MetaUpdateJob.create(jobBuildParams);
        }
    }
}

