/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.source;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.sdk.datasource.security.AbstractJdbcSourceConnectionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CommonJdbcSourceConnectionValidator
extends AbstractJdbcSourceConnectionValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonJdbcSourceConnectionValidator.class);
    private static final String JDBC_COLON = "jdbc:";
    private boolean parsed = false;
    private String scheme;
    private String host;
    private int port;
    private String path;
    private Map<String, List<String>> queryParams;

    public boolean isValid() {
        if (!this.parsed) {
            try {
                this.parseUrl();
            }
            catch (Exception e) {
                log.error("Error on parseUrl", (Throwable)e);
                return false;
            }
        }
        return this.validateQueryParamKeys();
    }

    private boolean validateQueryParamKeys() {
        Set validUrlParamKeys = this.settings.getValidUrlParamKeys();
        Set<String> userInputKeys = this.queryParams.keySet();
        return validUrlParamKeys.containsAll(userInputKeys);
    }

    private void parseUrl() {
        if (this.parsed) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new IllegalStateException("url cannot be empty");
        }
        if (!this.url.startsWith(JDBC_COLON)) {
            throw new IllegalStateException("url must start with jdbc:");
        }
        String noPrefixUrl = this.url.substring(JDBC_COLON.length());
        UriComponents uri = UriComponentsBuilder.fromUriString((String)noPrefixUrl).build();
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = uri.getPath();
        this.queryParams = uri.getQueryParams();
        this.parsed = true;
    }

    @Generated
    public CommonJdbcSourceConnectionValidator() {
    }
}

