/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampedRollingFileOutputDir {
    private static final Logger logger = LoggerFactory.getLogger(TimestampedRollingFileOutputDir.class);
    private final File outputDir;
    private final String fileNamePrefix;
    private final long maxFileCount;

    public TimestampedRollingFileOutputDir(File outputDir, String fileNamePrefix, long maxFileCount) {
        this.outputDir = outputDir;
        Preconditions.checkArgument((!fileNamePrefix.isEmpty() ? 1 : 0) != 0, (Object)"fileNamePrefix cannot be empty");
        Preconditions.checkArgument((maxFileCount > 0L ? 1 : 0) != 0, (Object)"maxFileCount cannot be less than 1");
        this.fileNamePrefix = this.normalizeFileNamePrefix(fileNamePrefix);
        this.maxFileCount = maxFileCount;
    }

    public File newOutputFile() throws IOException {
        File newFile;
        File[] files = this.outputDir.listFiles(this.fileFilter());
        Preconditions.checkNotNull((Object)files, (Object)("Invalid output directory " + this.outputDir));
        logger.debug("found {} output files under output dir", (Object)files.length);
        if (files.length > 0) {
            Arrays.sort(files, this.fileComparatorByAge());
            this.removeOldFiles(files);
        }
        if (!(newFile = new File(this.outputDir, this.newFileName())).createNewFile()) {
            logger.warn("output file {} already exists", (Object)newFile);
        }
        logger.debug("created output file {}", (Object)newFile);
        return newFile;
    }

    private String normalizeFileNamePrefix(String fileNamePrefix) {
        return fileNamePrefix.endsWith(".") ? fileNamePrefix : fileNamePrefix + ".";
    }

    protected FileFilter fileFilter() {
        return pathname -> pathname.getName().startsWith(this.fileNamePrefix);
    }

    protected Comparator<File> fileComparatorByAge() {
        return (file1, file2) -> file2.getName().compareTo(file1.getName());
    }

    protected void removeOldFiles(File[] files) {
        int i = files.length - 1;
        while ((long)i > this.maxFileCount - 2L) {
            String filePath = files[i].getPath();
            try {
                Files.deleteIfExists(files[i].toPath());
                logger.debug("Removed outdated file {}", (Object)filePath);
            }
            catch (IOException e) {
                logger.error("Error removing outdated file {}", (Object)filePath, (Object)e);
            }
            --i;
        }
    }

    protected String newFileName() {
        return this.fileNamePrefix + System.currentTimeMillis();
    }
}

