/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rest.aspect.WaitForSyncBeforeRPC;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.FavoriteRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OpenOptRecLayoutsResponse;
import org.apache.kylin.rest.response.OpenValidationResponse;
import org.apache.kylin.rest.response.OptRecLayoutsResponse;
import org.apache.kylin.rest.service.FavoriteRuleService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelSmartService;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenModelSmartController
extends NBasicController {
    @Autowired
    private ModelSmartService modelSmartService;
    @Autowired
    private OptRecService optRecService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private ModelService modelService;
    @Autowired
    private FavoriteRuleService favoriteRuleService;

    @ApiOperation(value="couldAnsweredByExistedModel", tags={"AI"})
    @PostMapping(value={"/validation"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<List<String>> couldAnsweredByExistedModel(@RequestBody FavoriteRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        OpenModelSmartController.checkSqlIsNotNull((List)request.getSqls());
        request.setProject(projectName);
        AbstractContext proposeContext = this.modelSmartService.probeRecommendation(request.getProject(), request.getSqls());
        List models = proposeContext.getProposedModels();
        return new EnvelopeResponse("000", models.stream().map(NDataModel::getAlias).collect(Collectors.toList()), "");
    }

    @VisibleForTesting
    public OpenValidationResponse batchSqlValidate(String project, List<String> sqls) {
        HashSet normalSqls = Sets.newHashSet();
        HashSet errorSqls = Sets.newHashSet();
        HashSet errorSqlDetailSet = Sets.newHashSet();
        Map validatedSqls = this.favoriteRuleService.batchSqlValidate(sqls, project);
        validatedSqls.forEach((sql, validateResult) -> {
            if (validateResult.isCapable()) {
                normalSqls.add(sql);
            } else {
                errorSqls.add(sql);
                errorSqlDetailSet.add(new OpenValidationResponse.ErrorSqlDetail(sql, validateResult.getSqlAdvices()));
            }
        });
        AbstractContext proposeContext = this.modelSmartService.probeRecommendation(project, (List)Lists.newArrayList((Iterable)normalSqls));
        Map uuidToModelMap = proposeContext.getRelatedModels().stream().collect(Collectors.toMap(RootPersistentEntity::getUuid, Function.identity()));
        HashMap answeredModelAlias = Maps.newHashMap();
        proposeContext.getAccelerateInfoMap().forEach((sql, accelerationInfo) -> {
            answeredModelAlias.putIfAbsent(sql, Sets.newHashSet());
            Set relatedLayouts = accelerationInfo.getRelatedLayouts();
            if (CollectionUtils.isNotEmpty((Collection)relatedLayouts)) {
                relatedLayouts.forEach(info -> {
                    String alias = ((NDataModel)uuidToModelMap.get(info.getModelId())).getAlias();
                    ((Set)answeredModelAlias.get(sql)).add(alias);
                });
            }
        });
        HashMap validSqlToModels = Maps.newHashMap();
        answeredModelAlias.forEach((sql, aliasSet) -> {
            List cfr_ignored_0 = validSqlToModels.put(sql, Lists.newArrayList((Iterable)aliasSet));
        });
        return new OpenValidationResponse((Map)validSqlToModels, (List)Lists.newArrayList((Iterable)errorSqls), (List)Lists.newArrayList((Iterable)errorSqlDetailSet));
    }

    @ApiOperation(value="answeredByExistedModel", tags={"AI"})
    @PostMapping(value={"/model_validation"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OpenValidationResponse> answeredByExistedModel(@RequestBody FavoriteRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.aclEvaluate.checkProjectWritePermission(request.getProject());
        OpenModelSmartController.checkNotEmpty((List)request.getSqls());
        OpenValidationResponse response = this.batchSqlValidate(request.getProject(), request.getSqls());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="getRecommendations", tags={"AI"})
    @GetMapping(value={"/{model_name:.+}/recommendations"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OpenOptRecLayoutsResponse> getRecommendations(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="recActionType", required=false, defaultValue="all") String recActionType) {
        String projectName = this.checkProjectName(project);
        this.checkProjectNotSemiAuto(projectName);
        this.aclEvaluate.checkProjectOperationDesignPermission(projectName);
        this.aclEvaluate.checkProjectReadPermission(projectName);
        String modelId = this.modelService.getModel(modelAlias, projectName).getId();
        this.checkRequiredArg("modelId", modelId);
        OptRecLayoutsResponse response = this.optRecService.getOptRecLayoutsResponse(projectName, modelId, recActionType);
        response.getLayouts().forEach(optRecLayoutResponse -> optRecLayoutResponse.setRecDetailResponse(null));
        return new EnvelopeResponse("000", (Object)new OpenOptRecLayoutsResponse(projectName, modelId, response), "");
    }
}

