/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedObjectType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.DefaultTypeNameProvider;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Types;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.TypeNameProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class TypeNameExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeNameExtractor.class);
    private final TypeResolver typeResolver;
    private final PluginRegistry<TypeNameProviderPlugin, DocumentationType> typeNameProviders;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public TypeNameExtractor(TypeResolver typeResolver, @Qualifier(value="typeNameProviderPluginRegistry") PluginRegistry<TypeNameProviderPlugin, DocumentationType> typeNameProviders, EnumTypeDeterminer enumTypeDeterminer) {
        this.typeResolver = typeResolver;
        this.typeNameProviders = typeNameProviders;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public String typeName(ModelContext context) {
        return this.typeName(context, new HashMap<String, String>());
    }

    public String typeName(ModelContext context, Map<String, String> knownNames) {
        ResolvedType type = this.asResolved((Type)context.getType());
        if (Collections.isContainerType(type)) {
            return Collections.containerType(type);
        }
        if (knownNames.containsKey(context.getTypeId())) {
            return knownNames.get(context.getTypeId());
        }
        return this.innerTypeName(type, context, knownNames);
    }

    private ResolvedType asResolved(Type type) {
        return this.typeResolver.resolve(type, new Type[0]);
    }

    private String genericTypeName(ResolvedType resolvedType, ModelContext context, Map<String, String> knownNames) {
        Class erasedType = resolvedType.getErasedType();
        GenericTypeNamingStrategy namingStrategy = context.getGenericNamingStrategy();
        String typeId = ModelContext.fromParent(context, resolvedType).getTypeId();
        if (knownNames.containsKey(typeId)) {
            return knownNames.get(typeId);
        }
        String simpleName = Optional.ofNullable(Collections.isContainerType(resolvedType) ? Collections.containerType(resolvedType) : this.typeName(erasedType)).orElse(this.modelName(ModelContext.fromParent(context, resolvedType), knownNames));
        StringBuilder sb = new StringBuilder(String.format("%s%s", simpleName, namingStrategy.getOpenGeneric()));
        boolean first = true;
        for (int index = 0; index < erasedType.getTypeParameters().length; ++index) {
            ResolvedType typeParam = (ResolvedType)resolvedType.getTypeParameters().get(index);
            if (first) {
                sb.append(this.innerTypeName(typeParam, context, knownNames));
                first = false;
                continue;
            }
            sb.append(String.format("%s%s", namingStrategy.getTypeListDelimiter(), this.innerTypeName(typeParam, context, knownNames)));
        }
        sb.append(namingStrategy.getCloseGeneric());
        return sb.toString();
    }

    private String innerTypeName(ResolvedType type, ModelContext context, Map<String, String> knownNames) {
        if (type.getTypeParameters().size() > 0 && type.getErasedType().getTypeParameters().length > 0) {
            return this.genericTypeName(type, context, knownNames);
        }
        return this.simpleTypeName(type, context, knownNames);
    }

    private String simpleTypeName(ResolvedType type, ModelContext context, Map<String, String> knownNames) {
        String typeName;
        Class erasedType = type.getErasedType();
        if (type instanceof ResolvedPrimitiveType) {
            return this.typeName(erasedType);
        }
        if (this.enumTypeDeterminer.isEnum(erasedType)) {
            return "string";
        }
        if (type instanceof ResolvedArrayType) {
            GenericTypeNamingStrategy namingStrategy = context.getGenericNamingStrategy();
            return String.format("Array%s%s%s", namingStrategy.getOpenGeneric(), this.simpleTypeName(type.getArrayElementType(), context, knownNames), namingStrategy.getCloseGeneric());
        }
        if (type instanceof ResolvedObjectType && (typeName = this.typeName(erasedType)) != null) {
            return typeName;
        }
        return this.modelName(ModelContext.fromParent(context, type), knownNames);
    }

    private String typeName(Class<?> erasedType) {
        return Types.typeNameFor(erasedType);
    }

    private String modelName(ModelContext context, Map<String, String> knownNames) {
        if (!Maps.isMapType(this.asResolved((Type)context.getType())) && knownNames.containsKey(context.getTypeId())) {
            return knownNames.get(context.getTypeId());
        }
        TypeNameProviderPlugin selected = this.typeNameProviders.getPluginOrDefaultFor(context.getDocumentationType(), new DefaultTypeNameProvider());
        String modelName = selected.nameFor(context.getType().getErasedType());
        LOG.debug("Generated unique model named: {}, with model id: {}", (Object)modelName, (Object)context.getTypeId());
        return modelName;
    }
}

