/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;
import springfox.documentation.spring.web.plugins.PathAndParametersEquivalence;

class DefaultRequestHandlerCombiner
implements RequestHandlerCombiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestHandlerCombiner.class);
    private static final PathAndParametersEquivalence EQUIVALENCE = new PathAndParametersEquivalence();

    DefaultRequestHandlerCombiner() {
    }

    @Override
    public List<RequestHandler> combine(List<RequestHandler> source) {
        ArrayList<RequestHandler> combined = new ArrayList<RequestHandler>();
        HashMap byPath = new HashMap();
        LOGGER.debug("Total number of request handlers {}", (Object)BuilderDefaults.nullToEmptyList(source).size());
        for (RequestHandler each : BuilderDefaults.nullToEmptyList(source)) {
            String pathKey = RequestHandler.sortedPaths(each.getPatternsCondition());
            LOGGER.debug("Adding key: {}, {}", (Object)pathKey, (Object)each.toString());
            byPath.putIfAbsent(pathKey, new ArrayList());
            ((List)byPath.get(pathKey)).add(each);
        }
        for (String key : byPath.keySet()) {
            combined.addAll(this.combined((Collection)byPath.get(key)));
        }
        LOGGER.debug("Combined number of request handlers {}", (Object)combined.size());
        return combined.stream().sorted(Orderings.byPatternsCondition()).collect(Collectors.toList());
    }

    private Collection<RequestHandler> combined(Collection<RequestHandler> requestHandlers) {
        ArrayList<RequestHandler> source = new ArrayList<RequestHandler>(requestHandlers);
        if (source.size() == 0 || source.size() == 1) {
            return requestHandlers;
        }
        Map<PathAndParametersEquivalence.Wrapper, List<RequestHandler>> groupByEquality = this.safeGroupBy(source);
        ArrayList<RequestHandler> combined = new ArrayList<RequestHandler>();
        groupByEquality.keySet().stream().sorted(this.wrapperComparator()).forEachOrdered(path -> {
            List handlers = (List)groupByEquality.get(path);
            RequestHandler toCombine = path.get();
            if (handlers.size() > 1) {
                for (RequestHandler each : handlers) {
                    if (each.equals(toCombine)) continue;
                    LOGGER.debug("Combining {} and {}", (Object)toCombine.toString(), (Object)each.toString());
                    toCombine = this.combine(toCombine, each);
                }
            }
            combined.add(toCombine);
        });
        return combined;
    }

    private Comparator<PathAndParametersEquivalence.Wrapper> wrapperComparator() {
        return (first, second) -> Orderings.byPatternsCondition().thenComparing(Orderings.byOperationName()).compare(first.get(), second.get());
    }

    private Map<PathAndParametersEquivalence.Wrapper, List<RequestHandler>> safeGroupBy(List<RequestHandler> source) {
        try {
            return source.stream().collect(Collectors.groupingBy(EQUIVALENCE::wrap, LinkedHashMap::new, Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("Unable to index request handlers {}. Request handlers with issues{}", (Object)e.getMessage(), (Object)this.keys(source));
            return Collections.emptyMap();
        }
    }

    private String keys(List<RequestHandler> source) {
        StringBuilder sb = new StringBuilder("Request Handlers with duplicate keys {");
        for (int i = 0; i < source.size(); ++i) {
            sb.append('\t').append(i).append(". ").append(source.get(i).key());
        }
        sb.append('}');
        return sb.toString();
    }

    private RequestHandler combine(RequestHandler first, RequestHandler second) {
        if (first.compareTo(second) < 0) {
            return new CombinedRequestHandler(first, second);
        }
        return new CombinedRequestHandler(second, first);
    }
}

