/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147481648)
public class OpenApiOperationTagsReader
implements OperationBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().tags(Stream.concat(this.operationTags(context).stream(), this.controllerTags(context).stream()).collect(Collectors.toSet()));
    }

    private Set<String> controllerTags(OperationContext context) {
        return this.tagsFromOasAnnotations(context).stream().map(springfox.documentation.service.Tag::getName).collect(Collectors.toSet());
    }

    private Set<springfox.documentation.service.Tag> tagsFromOasAnnotations(OperationContext context) {
        HashSet<springfox.documentation.service.Tag> controllerTags = new HashSet<springfox.documentation.service.Tag>();
        Optional<Tags> tags = context.findAnnotation(Tags.class);
        tags.ifPresent(ts -> Arrays.stream(ts.value()).forEach(t -> controllerTags.add(new springfox.documentation.service.Tag(t.name(), t.description()))));
        Optional<Tag> tag = context.findAnnotation(Tag.class);
        tag.ifPresent(t -> controllerTags.add(new springfox.documentation.service.Tag(t.name(), t.description())));
        return controllerTags;
    }

    private Set<String> operationTags(OperationContext context) {
        Optional<Operation> oasAnnotation = context.findAnnotation(Operation.class);
        return new HashSet<String>(oasAnnotation.map(this.tagsFromOasOperation()).orElse(new HashSet()));
    }

    private Function<Operation, Set<String>> tagsFromOasOperation() {
        return input -> Stream.of(input.tags()).filter(springfox.documentation.service.Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

