/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147481648)
public class OpenApiSchemaPropertyBuilder
implements ModelPropertyBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final ModelSpecificationFactory modelSpecifications;

    @Autowired
    public OpenApiSchemaPropertyBuilder(DescriptionResolver descriptions, ModelSpecificationFactory modelSpecifications) {
        this.descriptions = descriptions;
        this.modelSpecifications = modelSpecifications;
    }

    @Override
    public void apply(ModelPropertyContext context) {
        Schema annotation = context.getAnnotatedElement().flatMap(OpenApiSchemaPropertyBuilder::findSchemaAnnotation).orElse(context.getBeanPropertyDefinition().flatMap(b -> Annotations.findPropertyAnnotation(b, Schema.class)).orElse(null));
        if (annotation != null) {
            ModelSpecification modelSpecification = null;
            ResolvedType type = OpenApiSchemaPropertyBuilder.toType(context.getResolver()).apply(annotation);
            if (!ResolvedTypes.isVoid(type)) {
                modelSpecification = this.modelSpecifications.create(context.getOwner(), type);
            }
            context.getSpecificationBuilder().description(OpenApiSchemaPropertyBuilder.toDescription(this.descriptions).apply(annotation)).readOnly(annotation.readOnly()).isHidden(annotation.hidden()).type(modelSpecification).position(0).required(annotation.required()).example(annotation.example()).enumerationFacet(e -> e.allowedValues(Arrays.asList(annotation.allowableValues())));
        }
    }

    static Optional<Schema> findSchemaAnnotation(AnnotatedElement annotated) {
        Optional<Schema> annotation = Optional.empty();
        if (annotated instanceof Method) {
            annotation = Optional.ofNullable((Schema)AnnotationUtils.findAnnotation((Method)((Method)annotated), Schema.class));
        }
        return annotation.map(Optional::of).orElse(Optional.ofNullable((Schema)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, Schema.class)));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    static Function<Schema, ResolvedType> toType(TypeResolver resolver) {
        return annotation -> resolver.resolve(annotation.implementation(), new Type[0]);
    }

    static Function<Schema, String> toDescription(DescriptionResolver descriptions) {
        return annotation -> {
            String description = "";
            if (!StringUtils.isEmpty((Object)annotation.description())) {
                description = annotation.description();
            }
            return descriptions.resolve(description);
        };
    }
}

