/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.ClassSupport;
import springfox.documentation.service.Documentation;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
public class InMemorySwaggerResourcesProvider
implements SwaggerResourcesProvider,
ApplicationContextAware {
    private final String swagger1Url;
    private final String swagger2Url;
    private final String oas3Url;
    private boolean oas3Available;
    private boolean swagger1Available;
    private boolean swagger2Available;
    private final DocumentationCache documentationCache;
    private final boolean oas3DocketsPresent;
    private final boolean swagger2DocketsPresent;

    @Autowired
    public InMemorySwaggerResourcesProvider(Environment environment, DocumentationCache documentationCache, DocumentationPluginsManager pluginsManager) {
        this.oas3DocketsPresent = pluginsManager.documentationPlugins().stream().anyMatch(d -> d.supports(DocumentationType.OAS_30));
        this.swagger2DocketsPresent = pluginsManager.documentationPlugins().stream().anyMatch(d -> d.supports(DocumentationType.SWAGGER_2));
        this.swagger1Url = environment.getProperty("springfox.documentation.swagger.v1.path", "/api-docs");
        this.swagger2Url = this.fixup(environment.getProperty("springfox.documentation.swagger.v2.path", "/v2/api-docs"));
        this.oas3Url = this.fixup(environment.getProperty("springfox.documentation.open-api.v3.path", "/v3/api-docs"));
        this.documentationCache = documentationCache;
    }

    private String fixup(String path) {
        if (StringUtils.isEmpty((Object)path) || "/".equals(path) || "//".equals(path)) {
            return "/";
        }
        return StringUtils.trimTrailingCharacter((String)path.replace("//", "/"), (char)'/');
    }

    @Override
    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        for (Map.Entry<String, Documentation> entry : this.documentationCache.all().entrySet()) {
            SwaggerResource swaggerResource;
            String swaggerGroup = entry.getKey();
            if (this.swagger1Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url);
                swaggerResource.setSwaggerVersion("1.2");
                resources.add(swaggerResource);
            }
            if (this.swagger2Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger2Url);
                swaggerResource.setSwaggerVersion("2.0");
                resources.add(swaggerResource);
            }
            if (!this.oas3Available) continue;
            swaggerResource = this.resource(swaggerGroup, this.oas3Url);
            swaggerResource.setSwaggerVersion("3.0.3");
            resources.add(swaggerResource);
        }
        Collections.sort(resources);
        return resources;
    }

    private SwaggerResource resource(String swaggerGroup, String baseUrl) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setUrl(this.swaggerLocation(baseUrl, swaggerGroup));
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = Optional.of(swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ClassLoader classLoader = applicationContext.getClassLoader();
        this.swagger1Available = ClassSupport.classByName("springfox.documentation.swagger1.web.Swagger1Controller", classLoader).isPresent();
        this.swagger2Available = (ClassSupport.classByName("springfox.documentation.swagger2.web.Swagger2ControllerWebFlux", classLoader).isPresent() || ClassSupport.classByName("springfox.documentation.swagger2.web.Swagger2ControllerWebMvc", classLoader).isPresent()) && this.swagger2DocketsPresent;
        this.oas3Available = (ClassSupport.classByName("springfox.documentation.oas.web.OpenApiControllerWebFlux", classLoader).isPresent() || ClassSupport.classByName("springfox.documentation.oas.web.OpenApiControllerWebMvc", classLoader).isPresent()) && this.oas3DocketsPresent;
    }
}

