/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.SpecificationBuilder;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

class EntitySearchExtractor
implements EntityOperationsExtractor {
    EntitySearchExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        return StreamSupport.stream(context.searchMappings().getExportedMappings().spliterator(), false).map(mapping -> {
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), mapping.getMethod());
            return SpecificationBuilder.entityAction(context, handler).path(String.format("%s%s/search%s", context.basePath(), context.resourcePath(), mapping.getPath())).supportsMethod(RequestMethod.GET).build().map(get -> new SpringDataRestRequestHandler(context, (ActionSpecification)get));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

