/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock.jdbc;

import java.util.concurrent.locks.Lock;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.lock.jdbc.JdbcDistributedLockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.jdbc.lock.DefaultLockRepository;
import org.springframework.integration.jdbc.lock.JdbcLockRegistry;
import org.springframework.integration.jdbc.lock.LockRepository;

public class JdbcDistributedLockFactory
extends DistributedLockFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcDistributedLockFactory.class);

    public Lock getLockForClient(String client, String key) {
        DataSource dataSource = null;
        try {
            dataSource = JdbcDistributedLockUtil.getDataSource();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        DefaultLockRepository lockRepository = new DefaultLockRepository(dataSource, client);
        lockRepository.setPrefix(JdbcDistributedLockUtil.getGlobalDictLockTablePrefix());
        lockRepository.afterPropertiesSet();
        return new JdbcLockRegistry((LockRepository)lockRepository).obtain((Object)key);
    }

    public void initialize() {
        try {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setJDBCDistributedLockURL(config.getJDBCDistributedLockURL().toString());
            JdbcDistributedLockUtil.createDistributedLockTableIfNotExist();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

