/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ColumnAndConditionCriterion;
import org.mybatis.dynamic.sql.CriteriaGroup;
import org.mybatis.dynamic.sql.ExistsCriterion;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.util.Messages;

public abstract class AbstractBooleanExpressionDSL<T extends AbstractBooleanExpressionDSL<T>> {
    private SqlCriterion initialCriterion;
    protected final List<AndOrCriteriaGroup> subCriteria = new ArrayList<AndOrCriteriaGroup>();

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.and(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(column, condition), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.and(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T and(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(existsPredicate), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.and(initialCriterion, Arrays.asList(subCriteria));
    }

    @NotNull
    public T and(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("and", this.buildCriterion(initialCriterion), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T and(List<AndOrCriteriaGroup> criteria) {
        this.addSubCriteria("and", criteria);
        return this.getThis();
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, AndOrCriteriaGroup ... subCriteria) {
        return this.or(column, condition, Arrays.asList(subCriteria));
    }

    @NotNull
    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(column, condition), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, AndOrCriteriaGroup ... subCriteria) {
        return this.or(existsPredicate, Arrays.asList(subCriteria));
    }

    @NotNull
    public T or(ExistsPredicate existsPredicate, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(existsPredicate), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(SqlCriterion initialCriterion, AndOrCriteriaGroup ... subCriteria) {
        return this.or(initialCriterion, Arrays.asList(subCriteria));
    }

    @NotNull
    public T or(SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.addSubCriteria("or", this.buildCriterion(initialCriterion), subCriteria);
        return this.getThis();
    }

    @NotNull
    public T or(List<AndOrCriteriaGroup> criteria) {
        this.addSubCriteria("or", criteria);
        return this.getThis();
    }

    private <R> SqlCriterion buildCriterion(BindableColumn<R> column, VisitableCondition<R> condition) {
        return ColumnAndConditionCriterion.withColumn(column).withCondition(condition).build();
    }

    private SqlCriterion buildCriterion(ExistsPredicate existsPredicate) {
        return new ExistsCriterion.Builder().withExistsPredicate(existsPredicate).build();
    }

    private SqlCriterion buildCriterion(SqlCriterion initialCriterion) {
        return ((CriteriaGroup.Builder)new CriteriaGroup.Builder().withInitialCriterion(initialCriterion)).build();
    }

    private void addSubCriteria(String connector, SqlCriterion initialCriterion, List<AndOrCriteriaGroup> subCriteria) {
        this.subCriteria.add(new AndOrCriteriaGroup.Builder().withInitialCriterion(initialCriterion).withConnector(connector).withSubCriteria(subCriteria).build());
    }

    private void addSubCriteria(String connector, List<AndOrCriteriaGroup> criteria) {
        this.subCriteria.add(new AndOrCriteriaGroup.Builder().withConnector(connector).withSubCriteria(criteria).build());
    }

    protected void setInitialCriterion(SqlCriterion initialCriterion, StatementType statementType) {
        if (this.initialCriterion != null) {
            throw new InvalidSqlException(Messages.getString(statementType.messageNumber()));
        }
        this.initialCriterion = initialCriterion;
    }

    protected SqlCriterion getInitialCriterion() {
        return this.initialCriterion;
    }

    protected abstract T getThis();

    public static enum StatementType {
        WHERE("ERROR.32"),
        HAVING("ERROR.31");

        private final String messageNumber;

        public String messageNumber() {
            return this.messageNumber;
        }

        private StatementType(String messageNumber) {
            this.messageNumber = messageNumber;
        }
    }
}

