/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider;

public class DefaultMultiRowInsertStatementProvider<T>
implements MultiRowInsertStatementProvider<T> {
    private final List<T> records;
    private final String insertStatement;

    private DefaultMultiRowInsertStatementProvider(Builder<T> builder) {
        this.insertStatement = Objects.requireNonNull(((Builder)builder).insertStatement);
        this.records = Collections.unmodifiableList(((Builder)builder).records);
    }

    @Override
    public String getInsertStatement() {
        return this.insertStatement;
    }

    @Override
    public List<T> getRecords() {
        return this.records;
    }

    public static class Builder<T> {
        private final List<T> records = new ArrayList<T>();
        private String insertStatement;

        public Builder<T> withRecords(List<T> records) {
            this.records.addAll(records);
            return this;
        }

        public Builder<T> withInsertStatement(String insertStatement) {
            this.insertStatement = insertStatement;
            return this;
        }

        public DefaultMultiRowInsertStatementProvider<T> build() {
            return new DefaultMultiRowInsertStatementProvider(this);
        }
    }
}

