/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.TableExpressionVisitor;
import org.mybatis.dynamic.sql.select.SelectModel;

public class SubQuery
implements TableExpression {
    private final SelectModel selectModel;
    private final String alias;

    private SubQuery(Builder builder) {
        this.selectModel = Objects.requireNonNull(builder.selectModel);
        this.alias = builder.alias;
    }

    public SelectModel selectModel() {
        return this.selectModel;
    }

    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public boolean isSubQuery() {
        return true;
    }

    @Override
    public <R> R accept(TableExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static class Builder {
        private SelectModel selectModel;
        private String alias;

        public Builder withSelectModel(SelectModel selectModel) {
            this.selectModel = selectModel;
            return this;
        }

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public SubQuery build() {
            return new SubQuery(this);
        }
    }
}

