/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.AbstractQueryRendererBuilder;
import org.mybatis.dynamic.sql.select.render.DefaultSelectStatementProvider;
import org.mybatis.dynamic.sql.select.render.PagingModelRenderer;
import org.mybatis.dynamic.sql.select.render.QueryExpressionRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class SelectRenderer {
    private final SelectModel selectModel;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;
    private final TableAliasCalculator parentTableAliasCalculator;

    private SelectRenderer(Builder builder) {
        this.selectModel = Objects.requireNonNull(builder.selectModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.sequence = builder.sequence == null ? new AtomicInteger(1) : builder.sequence;
        this.parentTableAliasCalculator = builder.parentTableAliasCalculator;
    }

    public SelectStatementProvider render() {
        FragmentCollector fragmentCollector = this.selectModel.mapQueryExpressions(this::renderQueryExpression).collect(FragmentCollector.collect());
        this.renderOrderBy().ifPresent(fragmentCollector::add);
        this.renderPagingModel().ifPresent(fragmentCollector::add);
        return this.toSelectStatementProvider(fragmentCollector);
    }

    private SelectStatementProvider toSelectStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultSelectStatementProvider.withSelectStatement(fragmentCollector.fragments().collect(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters renderQueryExpression(QueryExpressionModel queryExpressionModel) {
        return ((QueryExpressionRenderer.Builder)((QueryExpressionRenderer.Builder)((QueryExpressionRenderer.Builder)QueryExpressionRenderer.withQueryExpression(queryExpressionModel).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).withParentTableAliasCalculator(this.parentTableAliasCalculator)).build().render();
    }

    private Optional<FragmentAndParameters> renderOrderBy() {
        return this.selectModel.orderByModel().map(this::renderOrderBy);
    }

    private FragmentAndParameters renderOrderBy(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    private Optional<FragmentAndParameters> renderPagingModel() {
        return this.selectModel.pagingModel().map(this::renderPagingModel);
    }

    private FragmentAndParameters renderPagingModel(PagingModel pagingModel) {
        return new PagingModelRenderer.Builder().withPagingModel(pagingModel).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build().render();
    }

    public static Builder withSelectModel(SelectModel selectModel) {
        return new Builder().withSelectModel(selectModel);
    }

    public static class Builder
    extends AbstractQueryRendererBuilder<Builder> {
        private SelectModel selectModel;

        public Builder withSelectModel(SelectModel selectModel) {
            this.selectModel = selectModel;
            return this;
        }

        public SelectRenderer build() {
            return new SelectRenderer(this);
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

