/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AWSTableLoadRequest;
import org.apache.kylin.rest.request.AutoMergeRequest;
import org.apache.kylin.rest.request.ReloadTableRequest;
import org.apache.kylin.rest.request.TableDescRequest;
import org.apache.kylin.rest.request.TableExclusionRequest;
import org.apache.kylin.rest.request.TableLoadRequest;
import org.apache.kylin.rest.request.TopTableRequest;
import org.apache.kylin.rest.request.UpdateAWSTableExtDescRequest;
import org.apache.kylin.rest.response.AutoMergeConfigResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ExcludedTableDetailResponse;
import org.apache.kylin.rest.response.ExcludedTableResponse;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.response.NHiveTableNameResponse;
import org.apache.kylin.rest.response.NInitTablesResponse;
import org.apache.kylin.rest.response.PreReloadTableResponse;
import org.apache.kylin.rest.response.PreUnloadTableResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.response.TableRefreshAll;
import org.apache.kylin.rest.response.TablesAndColumnsResponse;
import org.apache.kylin.rest.response.UpdateAWSTableExtDescResponse;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.TableExtService;
import org.apache.kylin.rest.service.TableSampleService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NTableController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NTableController.class);
    private static final String TABLE = "table";
    private static final int MAX_SAMPLING_ROWS = 20000000;
    private static final int MIN_SAMPLING_ROWS = 10000;
    private static final String DEPRECATED_FUNCTION = "This function is not supported anymore.";
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    @Qualifier(value="tableExtService")
    private TableExtService tableExtService;
    @Autowired
    @Qualifier(value="tableSampleService")
    private TableSampleService tableSampleService;
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;

    @ApiOperation(value="getTableDesc", tags={"AI"}, notes="Update Param: is_fuzzy, page_offset, page_size; Update Response: no format!")
    @GetMapping(value={""}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getTableDesc(@RequestParam(value="ext", required=false) boolean withExt, @RequestParam(value="project") String project, @RequestParam(value="table", required=false) String table, @RequestParam(value="database", required=false) String database, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="source_type", required=false, defaultValue="9") Integer sourceType) throws IOException {
        this.checkProjectName(project);
        int returnTableSize = TableUtils.calculateTableSize((int)offset, (int)limit);
        TableDescRequest tableDescRequest = new TableDescRequest(project, table, database, withExt, isFuzzy, Pair.newPair((Object)offset, (Object)limit), Collections.singletonList(sourceType));
        Pair tableDescWithActualSize = this.tableService.getTableDesc(tableDescRequest, returnTableSize);
        Map mockDataResponse = this.setCustomDataResponse("tables", tableDescWithActualSize, offset, limit);
        return new EnvelopeResponse("000", (Object)mockDataResponse, "");
    }

    @ApiOperation(value="getProjectTables", tags={"AI"}, notes="Update Param: is_fuzzy, page_offset, page_size")
    @GetMapping(value={"/project_tables"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<NInitTablesResponse> getProjectTables(@RequestParam(value="ext", required=false) boolean withExt, @RequestParam(value="project") String project, @RequestParam(value="table", required=false, defaultValue="") String table, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="with_excluded", required=false, defaultValue="true") boolean withExcluded, @RequestParam(value="source_type", required=false, defaultValue="9") List<Integer> sourceType) throws Exception {
        this.checkProjectName(project);
        TableDescRequest tableDescRequest = new TableDescRequest(project, table, "", withExt, isFuzzy, offset, limit, sourceType, withExcluded);
        NInitTablesResponse projectTables = this.tableService.getProjectTables(tableDescRequest, false);
        return new EnvelopeResponse("000", (Object)projectTables, "");
    }

    @ApiOperation(value="unloadTable", tags={"AI"}, notes="Update URL: {project}; Update Param: project")
    @DeleteMapping(value={"/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> unloadTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="cascade", defaultValue="false") Boolean cascade) {
        this.checkProjectName(project);
        String dbTblName = database + "." + table;
        this.tableService.unloadTable(project, dbTblName, cascade);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="prepareUnloadTable", tags={"AI"}, notes="Update URL: {project}; Update Param: project")
    @GetMapping(value={"/{database:.+}/{table:.+}/prepare_unload"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<PreUnloadTableResponse> prepareUnloadTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table) throws IOException {
        this.checkProjectName(project);
        PreUnloadTableResponse response = this.tableService.preUnloadTable(project, database + "." + table);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="partitionKey", tags={"AI"}, notes="Update Body: partition_column_format")
    @PostMapping(value={"/partition_key"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> setPartitionKey() {
        return new EnvelopeResponse("999", (Object)"", DEPRECATED_FUNCTION);
    }

    @ApiOperation(value="makeTop", tags={"AI"})
    @PostMapping(value={"/top"})
    @ResponseBody
    public EnvelopeResponse<String> setTableTop(@RequestBody TopTableRequest topTableRequest) {
        this.checkProjectName(topTableRequest.getProject());
        this.tableService.setTop(topTableRequest.getTable(), topTableRequest.getProject(), topTableRequest.isTop());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="loadTables", tags={"AI"}, notes="Update Body: data_source_type, need_sampling, sampling_rows")
    @PostMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> loadTables(@RequestBody TableLoadRequest tableLoadRequest) throws Exception {
        this.checkProjectName(tableLoadRequest.getProject());
        if (NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(tableLoadRequest.getProject()) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{tableLoadRequest.getProject()});
        }
        if (ArrayUtils.isEmpty((Object[])tableLoadRequest.getTables()) && ArrayUtils.isEmpty((Object[])tableLoadRequest.getDatabases())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "You should select at least one table or database to load!!");
        }
        LoadTableResponse loadTableResponse = this.tableExtService.loadTablesWithShortCircuit(tableLoadRequest);
        if (!loadTableResponse.getNeedRealSampling().isEmpty() && Boolean.TRUE.equals(tableLoadRequest.getNeedSampling())) {
            NTableController.checkSamplingRows(tableLoadRequest.getSamplingRows());
            this.tableSampleService.sampling(loadTableResponse.getNeedRealSampling(), tableLoadRequest.getProject(), tableLoadRequest.getSamplingRows().intValue(), tableLoadRequest.getPriority(), tableLoadRequest.getYarnQueue(), tableLoadRequest.getTag());
        }
        return new EnvelopeResponse("000", (Object)loadTableResponse, "");
    }

    @ApiOperation(value="loadAWSTablesCompatibleCrossAccount", tags={"N/A"}, notes="Update Body: data_source_type, need_sampling, sampling_rows, data_source_properties")
    @PostMapping(value={"/compatibility/aws"})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> loadAWSTablesCompatibleCrossAccount(@RequestBody AWSTableLoadRequest tableLoadRequest) throws Exception {
        this.checkProjectName(tableLoadRequest.getProject());
        if (NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(tableLoadRequest.getProject()) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{tableLoadRequest.getProject()});
        }
        if (CollectionUtils.isEmpty((Collection)tableLoadRequest.getTables())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "tables parameter must be not null !");
        }
        LoadTableResponse loadTableResponse = new LoadTableResponse();
        LoadTableResponse loadByTable = this.tableExtService.loadAWSTablesCompatibleCrossAccount(tableLoadRequest.getTables(), tableLoadRequest.getProject());
        loadTableResponse.getFailed().addAll(loadByTable.getFailed());
        loadTableResponse.getLoaded().addAll(loadByTable.getLoaded());
        if (!loadTableResponse.getLoaded().isEmpty() && Boolean.TRUE.equals(tableLoadRequest.getNeedSampling())) {
            NTableController.checkSamplingRows(tableLoadRequest.getSamplingRows());
            this.tableSampleService.sampling(loadTableResponse.getLoaded(), tableLoadRequest.getProject(), tableLoadRequest.getSamplingRows().intValue(), tableLoadRequest.getPriority(), tableLoadRequest.getYarnQueue(), tableLoadRequest.getTag());
        }
        return new EnvelopeResponse("000", (Object)loadTableResponse, "");
    }

    @ApiOperation(value="updateLoadedAWSTableExtProp", tags={"N/A"}, notes="Update Body: data_source_properties")
    @PutMapping(value={"/ext/prop/aws"})
    @ResponseBody
    public EnvelopeResponse<UpdateAWSTableExtDescResponse> updateLoadedAWSTableExtProp(@RequestBody UpdateAWSTableExtDescRequest request) {
        this.checkProjectName(request.getProject());
        if (NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject()) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{request.getProject()});
        }
        if (CollectionUtils.isEmpty((Collection)request.getTables())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "tables parameter must be not null !");
        }
        UpdateAWSTableExtDescResponse updateTableExtDescResponse = this.tableExtService.updateAWSLoadedTableExtProp(request);
        return new EnvelopeResponse("000", (Object)updateTableExtDescResponse, "");
    }

    @ApiOperation(value="databases", tags={"AI"})
    @GetMapping(value={"/databases"})
    @ResponseBody
    public EnvelopeResponse<List<String>> showDatabases(@RequestParam(value="project") String project) throws Exception {
        this.checkProjectName(project);
        List databases = this.tableService.getSourceDbNames(project);
        return new EnvelopeResponse("000", (Object)databases, "");
    }

    @ApiOperation(value="loadedDatabases", tags={"AI"})
    @GetMapping(value={"/loaded_databases"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Set<String>> getLoadedDatabases(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        Set loadedDatabases = this.tableService.getLoadedDatabases(project);
        return new EnvelopeResponse("000", (Object)loadedDatabases, "");
    }

    @ApiOperation(value="showTables", tags={"AI"}, notes="Update Param: data_source_type, page_offset, page_size; Update Response: total_size")
    @GetMapping(value={"/names"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<TableNameResponse>>> showTables(@RequestParam(value="project") String project, @RequestParam(value="data_source_type", required=false) Integer dataSourceType, @RequestParam(value="table", required=false) String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="database") String database) throws Exception {
        this.checkProjectName(project);
        List tables = this.tableService.getTableNameResponses(project, database, table);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)tables, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="showProjectTableNames", tags={"AI"}, notes="Update Param: data_source_type, page_offset, page_size")
    @GetMapping(value={"/project_table_names"})
    @ResponseBody
    public EnvelopeResponse<NInitTablesResponse> showProjectTableNames(@RequestParam(value="project") String project, @RequestParam(value="data_source_type", required=false) Integer dataSourceType, @RequestParam(value="table", required=false, defaultValue="") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) throws Exception {
        String projectName = this.checkProjectName(project);
        NInitTablesResponse data = this.tableService.getProjectTables(projectName, table, offset.intValue(), limit.intValue(), true, true, Collections.emptyList());
        return new EnvelopeResponse("000", (Object)data, "");
    }

    @ApiOperation(value="getTablesAndColumns", tags={"AI"}, notes="Update Param: page_offset, page_size; Update Response: total_size")
    @GetMapping(value={"/simple_table"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<TablesAndColumnsResponse>>> getTablesAndColomns(@RequestParam(value="project") String project, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        List responses = this.tableService.getTableAndColumns(project);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)responses, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="affectedDataRange", tags={"AI"})
    @GetMapping(value={"/affected_data_range"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> getRefreshAffectedDateRange() {
        return new EnvelopeResponse("000", (Object)"", DEPRECATED_FUNCTION);
    }

    @ApiOperation(value="updatePushdownMode", tags={"AI"}, notes="Update Body: pushdown_range_limited")
    @PutMapping(value={"/pushdown_mode"})
    @ResponseBody
    public EnvelopeResponse<String> setPushdownMode() {
        return new EnvelopeResponse("999", (Object)"", DEPRECATED_FUNCTION);
    }

    @ApiOperation(value="getPushdownMode", tags={"AI"})
    @GetMapping(value={"/pushdown_mode"})
    @ResponseBody
    public EnvelopeResponse<Boolean> getPushdownMode(@RequestParam(value="project") String project, @RequestParam(value="table") String table) {
        return new EnvelopeResponse("000", (Object)false, DEPRECATED_FUNCTION);
    }

    @ApiOperation(value="autoMergeConfig", tags={"DW"})
    @GetMapping(value={"/auto_merge_config"})
    @ResponseBody
    public EnvelopeResponse<AutoMergeConfigResponse> getAutoMergeConfig(@RequestParam(value="model", required=false) String modelId, @RequestParam(value="table", required=false) String tableName, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        if (StringUtils.isEmpty((CharSequence)modelId) && StringUtils.isEmpty((CharSequence)tableName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "model name or table name must be specified!");
        }
        AutoMergeConfigResponse response = null;
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            response = this.tableService.getAutoMergeConfigByModel(project, modelId);
        }
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="updateAutoMergeConfig", tags={"DW"}, notes="Update Body: auto_merge_enabled, auto_merge_time_ranges, volatile_range_number, volatile_range_enabled, volatile_range_type")
    @PutMapping(value={"/auto_merge_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateAutoMergeConfig(@RequestBody AutoMergeRequest autoMergeRequest) {
        this.checkProjectName(autoMergeRequest.getProject());
        if (ArrayUtils.isEmpty((Object[])autoMergeRequest.getAutoMergeTimeRanges())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "You should specify at least one autoMerge range!");
        }
        if (StringUtils.isEmpty((CharSequence)autoMergeRequest.getModel()) && StringUtils.isEmpty((CharSequence)autoMergeRequest.getTable())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "model name or table name must be specified!");
        }
        if (StringUtils.isNotEmpty((CharSequence)autoMergeRequest.getModel())) {
            this.tableService.setAutoMergeConfigByModel(autoMergeRequest.getProject(), autoMergeRequest);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="prepareReload", tags={"AI"})
    @GetMapping(value={"/prepare_reload"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<PreReloadTableResponse> preReloadTable(@RequestParam(value="project") String project, @RequestParam(value="table") String table) throws Exception {
        this.checkProjectName(project);
        PreReloadTableResponse result = this.tableService.preProcessBeforeReloadWithFailFast(project, table);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="reload", tags={"AI"})
    @PostMapping(value={"/reload"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> reloadTable(@RequestBody ReloadTableRequest request) {
        this.checkProjectName(request.getProject());
        if (StringUtils.isEmpty((CharSequence)request.getTable())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableNameCannotEmpty());
        }
        if (request.isNeedSample()) {
            NTableController.checkSamplingRows(request.getMaxRows());
        }
        this.tableService.reloadTable(request.getProject(), request.getTable(), request.isNeedSample(), request.getMaxRows(), request.isNeedBuild(), request.getPriority(), request.getYarnQueue());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="reloadHiveTableName", tags={"AI"}, notes="Update URL: table_name")
    @GetMapping(value={"/reload_hive_table_name"})
    @ResponseBody
    public EnvelopeResponse<NHiveTableNameResponse> reloadHiveTablename(@RequestParam(value="project", required=true, defaultValue="") String project, @RequestParam(value="force", required=false, defaultValue="false") boolean force) throws Exception {
        NHiveTableNameResponse response = this.tableService.loadProjectHiveTableNameToCacheImmediately(project, force);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="importSSB", tags={"DW"})
    @PostMapping(value={"/import_ssb"})
    @ResponseBody
    public EnvelopeResponse<String> importSSBData() {
        this.tableService.importSSBDataBase();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="importSSB", tags={"DW"})
    @GetMapping(value={"/ssb"})
    @ResponseBody
    public EnvelopeResponse<Boolean> checkSSB() {
        return new EnvelopeResponse("000", (Object)this.tableService.checkSSBDataBase(), "");
    }

    @Deprecated
    @ApiOperation(value="catalogCache", tags={"DW"})
    @PutMapping(value={"catalog_cache"}, produces={"application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse refreshCatalogCache(HttpServletRequest refreshRequest) {
        TableRefreshAll response = this.tableService.refreshAllCatalogCache(refreshRequest);
        return new EnvelopeResponse(response.getCode(), (Object)response, response.getMsg());
    }

    @ApiOperation(value="modelTables", tags={"AI"})
    @GetMapping(value={"/model_tables"})
    @ResponseBody
    public EnvelopeResponse<List<TableDesc>> getModelTables(@RequestParam(value="project") String project, @RequestParam(value="model_name") String modelName) {
        this.checkProjectName(project);
        List res = this.tableService.getTablesOfModel(project, modelName);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    public static void checkSamplingRows(int rows) {
        if (rows > 20000000 || rows < 10000) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_SAMPLING_RANGE_INVALID, new Object[]{10000, 20000000});
        }
    }

    @ApiOperation(value="getExcludedTables", notes="Add URL: {project}; ")
    @GetMapping(value={"/excluded_tables"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<ExcludedTableResponse>>> getExcludedTables(@RequestParam(value="project") String project, @RequestParam(value="page_offset", required=false, defaultValue="0") int pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") int pageSize, @RequestParam(value="view_partial_cols", required=false, defaultValue="true") boolean viewPartialCols, @RequestParam(value="key", required=false, defaultValue="") String searchKey) {
        List list = this.tableExtService.getExcludedTables(project, true, searchKey);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)list, (int)pageOffset, (int)pageSize), "");
    }

    @ApiOperation(value="getExcludedTable", notes="Add URL: {project}; ")
    @GetMapping(value={"/excluded_table"})
    @ResponseBody
    public EnvelopeResponse<ExcludedTableDetailResponse> getExcludedTable(@RequestParam(value="project") String project, @RequestParam(value="table") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") int pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") int pageSize, @RequestParam(value="key", required=false, defaultValue="") String searchKey, @RequestParam(value="col_type", required=false, defaultValue="0") int colType) {
        String projectName = this.checkProjectName(project);
        ExcludedTableDetailResponse response = this.tableExtService.getExcludedTable(projectName, table, pageOffset, pageSize, searchKey, colType == 1);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="updateExcludedTables", tags={"RR"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/excluded_tables"})
    @ResponseBody
    public EnvelopeResponse<String> updateExcludedTables(@RequestBody TableExclusionRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.tableExtService.updateExcludedTables(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

