/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/projects"})
public class NProjectControllerKylin
extends NBasicController {
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;

    @ApiOperation(value="getProjectsNoEnvelopeResponse", tags={"SM"})
    @GetMapping(value={""}, produces={"application/json"})
    @ResponseBody
    public List<ProjectInstance> getProjectsNoEnvelopeResponse(@RequestParam(value="projectName", required=false) String project, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer offset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer size, @RequestParam(value="exact", required=false, defaultValue="true") boolean exactMatch) {
        List readableProjects = this.projectService.getReadableProjects(project, exactMatch);
        return PagingUtil.cutPage((List)readableProjects, (int)offset, (int)size);
    }
}

