/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.initialize;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ModelBuildService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildAppInitializer
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildAppInitializer.class);
    @Autowired
    private JobService jobService;
    @Autowired
    private ModelBuildService modelBuildService;

    public void afterPropertiesSet() throws Exception {
        EventBusFactory.getInstance().registerService((Object)this.jobService);
        EventBusFactory.getInstance().registerService((Object)this.modelBuildService);
        BuildAppInitializer.checkSparkLogPath();
    }

    public static void checkSparkLogPath() throws IOException {
        Map sparkConfigOverride = KylinConfig.getInstanceFromEnv().getSparkConfigOverride();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (sparkConfigOverride.containsKey("spark.eventLog.dir")) {
            Path logPath;
            String logDir = ((String)sparkConfigOverride.get("spark.eventLog.dir")).trim();
            boolean eventLogEnabled = Boolean.parseBoolean((String)sparkConfigOverride.get("spark.eventLog.enabled"));
            if (eventLogEnabled && !logDir.isEmpty() && !fs.exists(logPath = new Path(logDir))) {
                fs.mkdirs(logPath);
            }
        }
    }
}

