/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Collections2;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NForestSpanningTree
extends NSpanningTree {
    @JsonProperty(value="nodes")
    protected final Map<Long, NSpanningTree.TreeNode> nodesMap = Maps.newTreeMap();
    protected final Map<Long, LayoutEntity> layoutMap = Maps.newHashMap();
    @JsonProperty(value="roots")
    private final List<NSpanningTree.TreeNode> roots = Lists.newArrayList();
    private static final Function<NSpanningTree.TreeNode, IndexEntity> TRANSFORM_FUNC = new Function<NSpanningTree.TreeNode, IndexEntity>(){

        @Override
        @Nullable
        public IndexEntity apply(@Nullable NSpanningTree.TreeNode input) {
            return input == null ? null : input.indexEntity;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(NForestSpanningTree.class);

    public NForestSpanningTree(Map<IndexEntity, Collection<LayoutEntity>> cuboids, String cacheKey) {
        super(cuboids, cacheKey);
        this.init();
    }

    public Map<Long, NSpanningTree.TreeNode> getNodesMap() {
        return this.nodesMap;
    }

    public List<NSpanningTree.TreeNode> getRoots() {
        return this.roots;
    }

    @Override
    public boolean isValid(long requestCuboid) {
        return this.nodesMap.containsKey(requestCuboid);
    }

    @Override
    public int getCuboidCount() {
        return this.nodesMap.size();
    }

    @Override
    public Collection<IndexEntity> getRootIndexEntities() {
        return Collections2.transform(this.roots, TRANSFORM_FUNC::apply);
    }

    @Override
    public Collection<LayoutEntity> getLayouts(IndexEntity indexEntity) {
        return (Collection)this.cuboids.get(indexEntity);
    }

    @Override
    public IndexEntity getIndexEntity(long indexId) {
        if (this.nodesMap.get(indexId) == null) {
            throw new IllegalStateException("Cuboid\uff08ID:" + indexId + ") does not exist!");
        }
        return this.nodesMap.get((Object)Long.valueOf((long)indexId)).indexEntity;
    }

    @Override
    public LayoutEntity getLayoutEntity(long layoutId) {
        return this.layoutMap.get(layoutId);
    }

    @Override
    public void decideTheNextLayer(Collection<IndexEntity> currentLayer, NDataSegment segment) {
        Comparator<IndexEntity> c1 = Comparator.comparingLong(o -> this.getRows((IndexEntity)o, segment));
        Comparator<IndexEntity> c2 = Comparator.comparingLong(IndexEntity::getId);
        List<IndexEntity> orderedIndexes = currentLayer.stream().sorted(c1.thenComparing(c2)).collect(Collectors.toList());
        orderedIndexes.forEach(index -> {
            this.adjustTree((IndexEntity)index, segment, true);
            logger.info("Adjust spanning tree. Current index plan: {}. Current index entity: {}. Its children: {}\n", new Object[]{index.getIndexPlan().getUuid(), index.getId(), Arrays.toString(this.getChildrenByIndexPlan((IndexEntity)index).stream().map(IndexEntity::getId).toArray())});
        });
    }

    @Override
    public Collection<IndexEntity> getChildrenByIndexPlan(IndexEntity parent) {
        NSpanningTree.TreeNode parentNode = this.nodesMap.get(parent.getId());
        Preconditions.checkState((boolean)parentNode.hasBeenDecided, (Object)"Node must have been decided before get its children.");
        return Collections2.transform(parentNode.children, TRANSFORM_FUNC::apply);
    }

    @Override
    public IndexEntity getParentByIndexEntity(IndexEntity child) {
        NSpanningTree.TreeNode childNode = this.nodesMap.get(child.getId());
        if (childNode.parent == null) {
            return null;
        }
        return childNode.parent.indexEntity;
    }

    @Override
    public IndexEntity getRootByIndexEntity(IndexEntity child) {
        NSpanningTree.TreeNode childNode = this.nodesMap.get(child.getId());
        return childNode.rootNode.indexEntity;
    }

    @Override
    public Collection<IndexEntity> getAllIndexEntities() {
        return Collections2.transform(this.nodesMap.values(), TRANSFORM_FUNC::apply);
    }

    @Override
    public Collection<IndexEntity> decideTheNextBatch(NDataSegment segment) {
        return null;
    }

    @Override
    public void addParentChildRelation(IndexEntity parent, IndexEntity child) {
        NSpanningTree.TreeNode parentNode = this.nodesMap.get(parent.getId());
        NSpanningTree.TreeNode childNode = this.nodesMap.get(child.getId());
        Preconditions.checkNotNull((Object)childNode, (Object)String.format(Locale.ROOT, "child index:%d don't exist", child.getId()));
        if (parentNode == null) {
            childNode.rootNode = childNode.parent = new NSpanningTree.TreeNode(parent, true);
            childNode.level = 0;
            return;
        }
        childNode.parent = parentNode;
        childNode.rootNode = parentNode.rootNode;
        childNode.level = parentNode.level + 1;
    }

    protected NSpanningTree.TreeNode adjustTree(IndexEntity parent, NDataSegment seg, Boolean needParentsBuild) {
        NSpanningTree.TreeNode parentNode = this.nodesMap.get(parent.getId());
        List<NSpanningTree.TreeNode> children = this.nodesMap.values().stream().filter(node -> this.shouldBeAdded((NSpanningTree.TreeNode)node, parent, seg, needParentsBuild)).collect(Collectors.toList());
        children.forEach(node -> {
            node.level = parentNode.level + 1;
            node.parent = parentNode;
            node.rootNode = parentNode.rootNode;
        });
        parentNode.children.addAll(children);
        parentNode.hasBeenDecided = true;
        return parentNode;
    }

    protected boolean shouldBeAdded(NSpanningTree.TreeNode node, IndexEntity parent, NDataSegment seg, Boolean needParentsBuild) {
        boolean shouldBeAdd;
        boolean bl = shouldBeAdd = node.parent == null && node.parentCandidates != null && node.parentCandidates.contains(parent);
        if (needParentsBuild.booleanValue()) {
            shouldBeAdd = shouldBeAdd && node.parentCandidates.stream().allMatch(c -> this.isBuilt((IndexEntity)c, seg));
        }
        return shouldBeAdd;
    }

    public boolean isBuilt(IndexEntity ie, NDataSegment seg) {
        return this.getLayoutFromSeg(ie, seg) != null;
    }

    protected long getRows(IndexEntity ie, NDataSegment seg) {
        return this.getLayoutFromSeg(ie, seg).getRows();
    }

    private NDataLayout getLayoutFromSeg(IndexEntity ie, NDataSegment seg) {
        return seg.getLayout(((LayoutEntity)Lists.newArrayList(this.getLayouts(ie)).get(0)).getId());
    }

    private void init() {
        new TreeBuilder(this.cuboids.keySet()).build();
    }

    private class TreeBuilder {
        private SortedSet<IndexEntity> sortedCuboids = Sets.newTreeSet((o1, o2) -> {
            int c = Integer.compare(o1.getDimensions().size(), o2.getDimensions().size());
            if (c != 0) {
                return c;
            }
            return Long.compare(o1.getId(), o2.getId());
        });

        private TreeBuilder(Collection<IndexEntity> cuboids) {
            if (cuboids != null) {
                this.sortedCuboids.addAll(cuboids);
            }
        }

        private void build() {
            for (IndexEntity cuboid : this.sortedCuboids) {
                this.addCuboid(cuboid);
            }
        }

        private void addCuboid(IndexEntity cuboid) {
            NSpanningTree.TreeNode node = new NSpanningTree.TreeNode(cuboid);
            List<IndexEntity> candidates = this.findDirectParentCandidates(cuboid);
            if (!candidates.isEmpty()) {
                node.parentCandidates = candidates;
            } else {
                node.level = 0;
                node.rootNode = node;
                NForestSpanningTree.this.roots.add(node);
            }
            NForestSpanningTree.this.nodesMap.put(cuboid.getId(), node);
            for (LayoutEntity layout : cuboid.getLayouts()) {
                NForestSpanningTree.this.layoutMap.put(layout.getId(), layout);
            }
        }

        private List<IndexEntity> findDirectParentCandidates(IndexEntity entity) {
            ArrayList<IndexEntity> candidates = new ArrayList<IndexEntity>();
            for (IndexEntity cuboid : this.sortedCuboids) {
                if (!cuboid.fullyDerive(entity) || !candidates.stream().noneMatch(candidate -> cuboid.fullyDerive((IndexEntity)candidate))) continue;
                candidates.add(cuboid);
            }
            return candidates;
        }
    }
}

