/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableIndexMatcher
extends IndexMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableIndexMatcher.class);

    public TableIndexMatcher(SQLDigest sqlDigest, ChooserContext chooserContext, NDataflow dataflow, ColExcludedChecker excludedChecker, AntiFlatChecker antiFlatChecker) {
        super(sqlDigest, chooserContext, dataflow, excludedChecker, antiFlatChecker);
        this.valid = this.fastValidCheckBeforeMatch();
    }

    @Override
    protected boolean fastValidCheckBeforeMatch() {
        this.sqlColumns = this.sqlDigest.getAllColumns().stream().map(this.tblColMap::get).collect(Collectors.toSet());
        return !this.sqlColumns.contains(null);
    }

    @Override
    public IndexMatcher.MatchResult match(LayoutEntity layout) {
        if (this.canSkipIndexMatch(layout.getIndex()) || !this.isValid()) {
            return new IndexMatcher.MatchResult();
        }
        log.trace("Matching table index");
        HashMap needDerive = Maps.newHashMap();
        Set<Integer> unmatchedCols = this.initUnmatchedColumnIds(layout);
        int penaltyFactor = 0;
        if (NProjectManager.getProjectConfig(this.project).useTableIndexAnswerSelectStarEnabled()) {
            penaltyFactor = unmatchedCols.size();
            unmatchedCols.removeAll(this.dataflow.getAllColumnsIndex());
            TableRef tableRef = this.dataflow.getModel().getTableNameMap().get(this.sqlDigest.getFactTable());
            if (this.sqlDigest.isRawQuery && this.sqlDigest.getAllColumns().size() == tableRef.getColumns().size()) {
                unmatchedCols.clear();
            }
        }
        this.goThruDerivedDims(layout.getIndex(), needDerive, unmatchedCols);
        boolean isMatch = unmatchedCols.isEmpty();
        if (!isMatch) {
            unmatchedCols.removeAll(this.filterExcludedDims(layout));
            log.debug("After rolling back to TableIndex to match, the unmatched columns are: {}", unmatchedCols);
            isMatch = unmatchedCols.isEmpty();
        }
        if (!isMatch) {
            if (log.isDebugEnabled()) {
                log.debug("Table index {} with unmatched columns {}", (Object)layout, unmatchedCols);
            }
            return new IndexMatcher.MatchResult(false, needDerive, CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.TABLE_INDEX_MISSING_COLS), Lists.newArrayList());
        }
        return new IndexMatcher.MatchResult(true, penaltyFactor, needDerive);
    }

    @Override
    protected boolean canSkipIndexMatch(IndexEntity index) {
        boolean isUseTableIndex = this.dataflow.getConfig().isUseTableIndexAnswerNonRawQuery() && !FunctionDesc.nonSupportFunTableIndex(this.sqlDigest.getAggregations());
        return !index.isTableIndex() || !this.sqlDigest.isRawQuery && !isUseTableIndex;
    }
}

