/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.metadata.Manager;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDataSegmentManager
extends Manager<NDataSegment> {
    private static final Logger logger = LoggerFactory.getLogger(NDataSegmentManager.class);

    protected NDataSegmentManager(KylinConfig cfg, String project, MetadataType type) {
        super(cfg, project, type);
    }

    static NDataSegmentManager newInstance(KylinConfig config, String project) {
        return new NDataSegmentManager(config, project, MetadataType.SEGMENT);
    }

    public static NDataSegmentManager getInstance(KylinConfig config, String project) {
        return (NDataSegmentManager)config.getManager(project, NDataSegmentManager.class);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public String name() {
        return "NDataSegmentManager";
    }

    @Override
    public Class<NDataSegment> entityType() {
        return NDataSegment.class;
    }

    @Override
    protected void initCrud(MetadataType type, String project) {
        this.crud = new CachedCrudAssist<NDataSegment>(this.getStore(), type, project, this.entityType()){

            @Override
            protected NDataSegment initEntityAfterReload(NDataSegment entity, String resourceName) {
                entity.initAfterReload();
                return entity;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
    }

    @Override
    public NDataSegment copyForWrite(NDataSegment entity) {
        NDataSegment copy = super.copyForWrite(entity);
        if (entity.getDataflow() != null) {
            copy.setDataflow(entity.getDataflow());
        }
        return copy;
    }

    @Override
    public NDataSegment copy(NDataSegment entity) {
        NDataSegment copy = super.copy(entity);
        if (entity.getDataflow() != null) {
            copy.setDataflow(entity.getDataflow());
        }
        return copy;
    }

    @Override
    public Optional<NDataSegment> get(String resourceName) {
        Optional<NDataSegment> segment = this.getWithoutInitDataflow(resourceName);
        segment.ifPresent(NDataSegment::initDataFlow);
        return segment;
    }

    public Optional<NDataSegment> getWithoutInitDataflow(String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.crud.get(resourceName));
    }

    public Segments<NDataSegment> getSegmentsUnderDataflow(NDataflow df) {
        return this.getSegments(df, df.getSegmentUuids());
    }

    public Segments<NDataSegment> getSegments(NDataflow df, Collection<String> segIds) {
        return this.getSegmentsWithForceCatchupIfInconsistent(df, segIds, true);
    }

    private Segments<NDataSegment> getSegmentsWithForceCatchupIfInconsistent(NDataflow df, Collection<String> segIds, boolean needCatch) {
        List<NDataSegment> segments = segIds.stream().map(uuid -> this.getWithoutInitDataflow((String)uuid).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        if (segments.size() < segIds.size()) {
            logger.warn("Segments are inconsistency with dataflow, force to catchup: {}", (Object)needCatch);
            if (needCatch) {
                try {
                    ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getAuditLogStore().catchupWithTimeoutInNewThread();
                }
                catch (KylinRuntimeException e) {
                    logger.warn("Manually catchup auditlog Failed.", (Throwable)e);
                }
                return this.getSegmentsWithForceCatchupIfInconsistent(df, segIds, false);
            }
        }
        segments.forEach(seg -> seg.setDataflow(df));
        return new Segments<NDataSegment>(segments);
    }
}

