/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.cube.planner.algorithm.BenefitPolicy;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidBenefitModel;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPUSCalculator
implements BenefitPolicy {
    private static Logger logger = LoggerFactory.getLogger(BPUSCalculator.class);
    protected final CuboidStats cuboidStats;
    protected final ImmutableMap<BigInteger, Long> initCuboidAggCostMap;
    protected final Map<BigInteger, Long> processCuboidAggCostMap;

    public BPUSCalculator(CuboidStats cuboidStats) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = ImmutableMap.copyOf(this.initCuboidAggCostMap());
        this.processCuboidAggCostMap = Maps.newHashMap(this.initCuboidAggCostMap);
    }

    protected BPUSCalculator(CuboidStats cuboidStats, ImmutableMap<BigInteger, Long> initCuboidAggCostMap) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = initCuboidAggCostMap;
        this.processCuboidAggCostMap = Maps.newHashMap(initCuboidAggCostMap);
    }

    private Map<BigInteger, Long> initCuboidAggCostMap() {
        HashMap cuboidAggCostMap = Maps.newHashMap();
        for (BigInteger cuboid : this.cuboidStats.getAllCuboidsForMandatory()) {
            if (this.getCuboidCost(cuboid) == null) continue;
            cuboidAggCostMap.put(cuboid, this.getCuboidCost(cuboid));
        }
        long baseCuboidCost = this.getCuboidCost(this.cuboidStats.getBaseCuboid());
        for (BigInteger cuboid : this.cuboidStats.getAllCuboidsForSelection()) {
            long leastCost = baseCuboidCost;
            for (Map.Entry cuboidTargetEntry : cuboidAggCostMap.entrySet()) {
                if (!cuboid.or((BigInteger)cuboidTargetEntry.getKey()).equals(cuboidTargetEntry.getKey()) || leastCost <= (Long)cuboidTargetEntry.getValue()) continue;
                leastCost = (Long)cuboidTargetEntry.getValue();
            }
            cuboidAggCostMap.put(cuboid, leastCost);
        }
        return cuboidAggCostMap;
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefit(BigInteger cuboid, Set<BigInteger> selected) {
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (BigInteger descendant : this.cuboidStats.getAllDescendants(cuboid)) {
            double costSaving;
            if (selected.contains(descendant) || !((costSaving = this.getCostSaving(descendant, cuboid)) > 0.0)) continue;
            totalCostSaving += costSaving;
            ++benefitCount;
        }
        double spaceCost = this.calculateSpaceCost(cuboid);
        double benefitPerUnitSpace = totalCostSaving / spaceCost;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefitTotal(Set<BigInteger> cuboidsToAdd, Set<BigInteger> selected) {
        HashSet selectedInner = Sets.newHashSet(selected);
        HashMap cuboidAggCostMapCopy = Maps.newHashMap(this.processCuboidAggCostMap);
        for (BigInteger cuboid : cuboidsToAdd) {
            selectedInner.add(cuboid);
            this.propagateAggregationCost(cuboid, selectedInner, cuboidAggCostMapCopy);
        }
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Map.Entry entry : cuboidAggCostMapCopy.entrySet()) {
            if ((Long)entry.getValue() >= this.processCuboidAggCostMap.get(entry.getKey())) continue;
            totalCostSaving += (double)(this.processCuboidAggCostMap.get(entry.getKey()) - (Long)entry.getValue());
            ++benefitCount;
        }
        double benefitPerUnitSpace = totalCostSaving;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    protected double getCostSaving(BigInteger descendant, BigInteger cuboid) {
        long cuboidCost = this.getCuboidCost(cuboid);
        long descendantAggCost = this.getCuboidAggregationCost(descendant);
        return (double)descendantAggCost - (double)cuboidCost;
    }

    protected Long getCuboidCost(BigInteger cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid);
    }

    private long getCuboidAggregationCost(BigInteger cuboid) {
        return this.processCuboidAggCostMap.get(cuboid);
    }

    @Override
    public boolean ifEfficient(CuboidBenefitModel best) {
        if (best.getBenefit() < this.getMinBenefitRatio()) {
            logger.info(String.format(Locale.ROOT, "The recommended cuboid %s doesn't meet minimum benifit ratio %f", best, this.getMinBenefitRatio()));
            return false;
        }
        return true;
    }

    public double getMinBenefitRatio() {
        return this.cuboidStats.getBpusMinBenefitRatio();
    }

    @Override
    public void propagateAggregationCost(BigInteger cuboid, Set<BigInteger> selected) {
        this.propagateAggregationCost(cuboid, selected, this.processCuboidAggCostMap);
    }

    private void propagateAggregationCost(BigInteger cuboid, Set<BigInteger> selected, Map<BigInteger, Long> processCuboidAggCostMap) {
        long aggregationCost = this.getCuboidCost(cuboid);
        Set<BigInteger> childrenCuboids = this.cuboidStats.getAllDescendants(cuboid);
        for (BigInteger child : childrenCuboids) {
            if (selected.contains(child) || aggregationCost >= this.getCuboidAggregationCost(child)) continue;
            processCuboidAggCostMap.put(child, aggregationCost);
        }
    }

    public double calculateSpaceCost(BigInteger cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid).longValue();
    }

    @Override
    public BenefitPolicy getInstance() {
        return new BPUSCalculator(this.cuboidStats, this.initCuboidAggCostMap);
    }
}

