/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class BooleanSerializer
extends DataTypeSerializer<Long> {
    public static final String[] TRUE_VALUE_SET = new String[]{"true", "t", "on", "yes"};

    public BooleanSerializer(DataType type) {
    }

    public void serialize(Long value, ByteBuffer out) {
        out.putLong(value);
    }

    public Long deserialize(ByteBuffer in) {
        return in.getLong();
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 8;
    }

    @Override
    public int maxLength() {
        return 8;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public Long valueOf(String str) {
        return str == null ? 0L : (long)BooleanUtils.toInteger((boolean)ArrayUtils.contains((Object[])TRUE_VALUE_SET, (Object)str.toLowerCase(Locale.ROOT)));
    }
}

