/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.insensitive;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.insensitive.InsensitiveRequest;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UserInsensitiveRequest
extends InsensitiveRequest {
    @Override
    default public List<String> inSensitiveFields() {
        return Collections.singletonList("username");
    }

    @Override
    default public void updateField() {
        for (String fieldName : this.inSensitiveFields()) {
            try {
                Field field = this.getDeclaredField(this.getClass(), fieldName);
                if (field == null) {
                    return;
                }
                Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
                String username = (String)field.get(this);
                if (StringUtils.isEmpty((CharSequence)username)) {
                    return;
                }
                NKylinUserManager userManager = NKylinUserManager.getInstance(KylinConfig.getInstanceFromEnv());
                ManagedUser managedUser = userManager.get(username);
                if (managedUser == null) {
                    return;
                }
                field.set(this, managedUser.getUsername());
            }
            catch (IllegalAccessException e) {
                LogHolder.log.warn("update username failed ", (Throwable)e);
            }
        }
    }

    public static final class LogHolder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(LogHolder.class);
    }
}

