/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.graph.Edge;
import org.apache.kylin.metadata.model.graph.IJoinEdgeMatcher;

public class JoinsGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TableRef center;
    private final Map<String, TableRef> vertexMap = Maps.newLinkedHashMap();
    private final Map<TableRef, VertexInfo<Edge>> vertexInfoMap = Maps.newHashMap();
    private final Set<Edge> edges = Sets.newHashSet();

    public JoinsGraph(TableRef root, List<JoinDesc> joins) {
        this(root, joins, true);
    }

    public JoinsGraph(TableRef root, List<JoinDesc> joins, boolean needSwapJoin) {
        this.center = root;
        this.addVertex(root);
        List<Pair<JoinDesc, Boolean>> newJoinsPair = this.swapJoinDescs(joins, needSwapJoin);
        for (Pair<JoinDesc, Boolean> pair : newJoinsPair) {
            JoinDesc join = (JoinDesc)pair.getFirst();
            Boolean isSwap = (Boolean)pair.getSecond();
            Preconditions.checkState((boolean)Arrays.stream(join.getForeignKeyColumns()).allMatch(TblColRef::isQualified));
            Preconditions.checkState((boolean)Arrays.stream(join.getPrimaryKeyColumns()).allMatch(TblColRef::isQualified));
            this.addVertex(join.getPKSide());
            this.addVertex(join.getFKSide());
            this.addEdge(join, isSwap);
        }
        this.validate(joins);
    }

    public void addVertex(TableRef table) {
        if (this.vertexMap.containsKey(table.getAlias())) {
            return;
        }
        this.vertexMap.put(table.getAlias(), table);
        this.vertexInfoMap.computeIfAbsent(table, f -> new VertexInfo());
    }

    public void addEdge(JoinDesc join, boolean swapJoin) {
        Edge edge = new Edge(join, swapJoin);
        this.vertexInfoMap.get((Object)join.getPKSide()).inEdges.add(edge);
        this.vertexInfoMap.get((Object)join.getFKSide()).outEdges.add(edge);
        this.edges.add(edge);
    }

    private void validate(List<JoinDesc> joins) {
        for (JoinDesc join : joins) {
            TableRef fkSide = join.getFKSide();
            Preconditions.checkNotNull((Object)this.vertexMap.get(fkSide.getAlias()));
            Preconditions.checkState((boolean)this.vertexMap.get(fkSide.getAlias()).equals(fkSide));
        }
        Preconditions.checkState((this.vertexMap.size() == joins.size() + 1 ? 1 : 0) != 0);
    }

    private List<Pair<JoinDesc, Boolean>> swapJoinDescs(List<JoinDesc> joins, boolean needSwapJoin) {
        ArrayList newJoins = Lists.newArrayList();
        for (JoinDesc join : joins) {
            newJoins.add(Pair.newPair((Object)join, (Object)false));
            if (!join.isInnerJoin() && !join.isLeftOrInnerJoin() || !needSwapJoin) continue;
            newJoins.add(Pair.newPair((Object)this.swapJoinDesc(join), (Object)true));
        }
        return newJoins;
    }

    private JoinDesc swapJoinDesc(JoinDesc originJoinDesc) {
        JoinDesc swapedJoinDesc = new JoinDesc();
        swapedJoinDesc.setType(originJoinDesc.getType());
        swapedJoinDesc.setPrimaryKey(originJoinDesc.getForeignKey());
        swapedJoinDesc.setForeignKey(originJoinDesc.getPrimaryKey());
        swapedJoinDesc.setNonEquiJoinCondition(originJoinDesc.getNonEquiJoinCondition());
        swapedJoinDesc.setPrimaryTable(originJoinDesc.getForeignTable());
        swapedJoinDesc.setForeignTable(originJoinDesc.getPrimaryTable());
        swapedJoinDesc.setPrimaryKeyColumns(originJoinDesc.getForeignKeyColumns());
        swapedJoinDesc.setForeignKeyColumns(originJoinDesc.getPrimaryKeyColumns());
        swapedJoinDesc.setPrimaryTableRef(originJoinDesc.getForeignTableRef());
        swapedJoinDesc.setForeignTableRef(originJoinDesc.getPrimaryTableRef());
        swapedJoinDesc.setLeftOrInner(originJoinDesc.isLeftOrInnerJoin());
        return swapedJoinDesc;
    }

    public void setJoinEdgeMatcher(IJoinEdgeMatcher joinEdgeMatcher) {
        this.edges.forEach(edge -> edge.setJoinEdgeMatcher(joinEdgeMatcher));
    }

    public List<Edge> outwardEdges(TableRef table) {
        return Lists.newArrayList(this.vertexInfoMap.get((Object)table).outEdges);
    }

    public List<Edge> inwardEdges(TableRef table) {
        return Lists.newArrayList(this.vertexInfoMap.get((Object)table).inEdges);
    }

    public String getCenterTableIdentity() {
        return this.center.getTableIdentity();
    }

    public boolean match(JoinsGraph pattern, Map<String, String> matchAliasMap) {
        return this.match(pattern, matchAliasMap, false);
    }

    public boolean match(JoinsGraph pattern, Map<String, String> matchAliasMap, boolean matchPartial) {
        return this.match(pattern, matchAliasMap, matchPartial, false);
    }

    public boolean match(JoinsGraph pattern, Map<String, String> matchAliasMap, boolean matchPartial, boolean matchPartialNonEquiJoin) {
        if (Objects.isNull(pattern) || Objects.isNull(pattern.center)) {
            throw new IllegalArgumentException("pattern(model) should have a center: " + pattern);
        }
        List<TableRef> candidatesOfQCenter = this.searchCenter(pattern.getCenterTableIdentity());
        for (TableRef candidateCenter : candidatesOfQCenter) {
            ArrayList unmatchedPatternOutEdges = Lists.newArrayList();
            HashMap allMatchedTableMap = Maps.newHashMap();
            ArrayList toMatchTableList = Lists.newArrayList();
            toMatchTableList.add(Pair.newPair((Object)candidateCenter, (Object)pattern.center));
            this.match0(pattern, toMatchTableList, unmatchedPatternOutEdges, allMatchedTableMap);
            if (!toMatchTableList.isEmpty() || allMatchedTableMap.size() != this.vertexMap.size() || !unmatchedPatternOutEdges.isEmpty() && !unmatchedPatternOutEdges.stream().allMatch(Edge::isLeftJoin) && !matchPartial || allMatchedTableMap.isEmpty() || !matchPartialNonEquiJoin && !this.checkNonEquiJoinMatches(allMatchedTableMap, pattern)) continue;
            matchAliasMap.clear();
            matchAliasMap.putAll(allMatchedTableMap.entrySet().stream().collect(Collectors.toMap(e -> ((TableRef)e.getKey()).getAlias(), e -> ((TableRef)e.getValue()).getAlias())));
            return true;
        }
        return false;
    }

    private void match0(JoinsGraph pattern, List<Pair<TableRef, TableRef>> toMatchTableList, List<Edge> unmatchedPatternOutEdges, Map<TableRef, TableRef> matchedTableMap) {
        for (int i = 0; i < toMatchTableList.size(); ++i) {
            Pair<TableRef, TableRef> pair = toMatchTableList.get(i);
            TableRef queryFKSide = (TableRef)pair.getFirst();
            TableRef patternFKSide = (TableRef)pair.getSecond();
            List<Edge> queryOutEdges = this.outwardEdges(queryFKSide);
            HashSet patternOutEdges = Sets.newHashSet(pattern.outwardEdges(patternFKSide));
            Iterator<Edge> queryOutEdgesIter = queryOutEdges.iterator();
            while (queryOutEdgesIter.hasNext()) {
                Edge queryOutEdge = queryOutEdgesIter.next();
                TableRef queryPKSide = queryOutEdge.otherSide(queryFKSide);
                Edge matchedPatternEdge = this.findOutEdgeFromDualTable(pattern, patternOutEdges, queryPKSide, queryOutEdge);
                boolean patternEdgeNotMatch = Objects.isNull(matchedPatternEdge);
                if (queryOutEdge.isLeftOrInnerJoin() && (patternOutEdges.isEmpty() || patternEdgeNotMatch)) {
                    queryOutEdgesIter.remove();
                    continue;
                }
                if (patternEdgeNotMatch) break;
                queryOutEdgesIter.remove();
                patternOutEdges.remove(matchedPatternEdge);
                TableRef patternPKSide = matchedPatternEdge.otherSide(patternFKSide);
                this.addIfAbsent(toMatchTableList, Pair.newPair((Object)queryPKSide, (Object)patternPKSide));
            }
            if (CollectionUtils.isNotEmpty(queryOutEdges)) break;
            matchedTableMap.put(queryFKSide, patternFKSide);
            unmatchedPatternOutEdges.addAll(patternOutEdges);
        }
        List matchedList = matchedTableMap.entrySet().stream().map(e -> Pair.newPair(e.getKey(), e.getValue())).collect(Collectors.toList());
        toMatchTableList.removeAll(matchedList);
    }

    private Edge findOutEdgeFromDualTable(JoinsGraph pattern, Set<Edge> patternOutEdges, TableRef queryPKSide, Edge queryOutEdge) {
        Set matchedEdges = patternOutEdges.stream().filter(outPatternEdge -> StringUtils.equals((CharSequence)queryPKSide.getTableIdentity(), (CharSequence)outPatternEdge.pkSide().getTableIdentity()) && queryOutEdge.equals(outPatternEdge)).collect(Collectors.toSet());
        if (matchedEdges.size() == 1) {
            return (Edge)matchedEdges.iterator().next();
        }
        for (Edge matchedEdge : matchedEdges) {
            int patternOutEdgeSize;
            TableRef patternPKSide = matchedEdge.pkSide();
            int queryOutEdgeSize = this.vertexInfoMap.get((Object)queryPKSide).outEdges.size();
            if (queryOutEdgeSize != (patternOutEdgeSize = pattern.vertexInfoMap.get((Object)patternPKSide).outEdges.size())) continue;
            return matchedEdge;
        }
        return null;
    }

    private List<TableRef> searchCenter(String tableIdentity) {
        return this.vertexInfoMap.keySet().stream().filter(table -> StringUtils.equals((CharSequence)table.getTableIdentity(), (CharSequence)tableIdentity)).collect(Collectors.toList());
    }

    public boolean checkNonEquiJoinMatches(Map<TableRef, TableRef> matches, JoinsGraph pattern) {
        for (Map.Entry<TableRef, VertexInfo<Edge>> entry : pattern.vertexInfoMap.entrySet()) {
            TableRef table = entry.getKey();
            List outEdges = entry.getValue().outEdges;
            for (Edge outgoingEdge : outEdges) {
                if (!outgoingEdge.isNonEquiJoin() || matches.containsValue(table) && matches.containsValue(outgoingEdge.pkSide())) continue;
                return false;
            }
        }
        return true;
    }

    public List<TableRef> getAllTblRefNodes() {
        return Lists.newArrayList(this.vertexMap.values());
    }

    public void normalize() {
        Set edgeSet = this.edges.stream().filter(e -> !e.isSwapJoin()).collect(Collectors.toSet());
        for (Edge edge : edgeSet) {
            TableRef fkSide;
            List edgeList;
            if (edge.isLeftJoin() && !edge.isLeftOrInnerJoin() || CollectionUtils.isEmpty(edgeList = this.inwardEdges(fkSide = edge.fkSide()).stream().filter(e -> !e.isSwapJoin()).collect(Collectors.toList()))) continue;
            for (Edge targetEdge : edgeList) {
                if (edge.equals(targetEdge) || !fkSide.equals(targetEdge.pkSide()) || targetEdge.isLeftOrInnerJoin()) continue;
                this.setJoinToLeftOrInner(targetEdge.join);
                this.normalize();
            }
        }
    }

    public void setJoinToLeftOrInner(JoinDesc join) {
        if (!join.isLeftJoin()) {
            join.setLeftOrInner(true);
            Edge swapEdge = this.edges.stream().filter(e -> e.isJoinMatched(this.swapJoinDesc(join))).findFirst().orElse(null);
            if (swapEdge == null) {
                return;
            }
            swapEdge.join.setLeftOrInner(true);
            return;
        }
        Edge edge = this.edges.stream().filter(e -> e.isJoinMatched(join)).findFirst().orElse(null);
        if (edge == null) {
            return;
        }
        join.setLeftOrInner(true);
        JoinDesc swapJoin = this.swapJoinDesc(join);
        Edge swapEdge = new Edge(swapJoin, true);
        this.vertexInfoMap.computeIfAbsent(swapEdge.pkSide(), f -> new VertexInfo());
        this.vertexInfoMap.computeIfAbsent(swapEdge.fkSide(), f -> new VertexInfo());
        this.addIfAbsent(this.vertexInfoMap.get((Object)swapEdge.fkSide()).outEdges, swapEdge);
        this.addIfAbsent(this.vertexInfoMap.get((Object)swapEdge.pkSide()).inEdges, swapEdge);
        if (this.edges.stream().noneMatch(e -> e.isJoinMatched(swapJoin))) {
            this.edges.add(swapEdge);
        }
    }

    public Map<String, String> matchAlias(JoinsGraph joinsGraph, KylinConfig kylinConfig) {
        HashMap matchAliasMap = Maps.newHashMap();
        this.match(joinsGraph, matchAliasMap, kylinConfig.isQueryMatchPartialInnerJoinModel(), kylinConfig.partialMatchNonEquiJoins());
        return matchAliasMap;
    }

    public Map<String, String> matchAlias(JoinsGraph joinsGraph, boolean matchPartial) {
        HashMap matchAliasMap = Maps.newHashMap();
        this.match(joinsGraph, matchAliasMap, matchPartial);
        return matchAliasMap;
    }

    public JoinDesc getJoinByPKSide(TableRef pkTable) {
        Edge edge = this.getEdgeByPKSide(pkTable);
        return Objects.nonNull(edge) ? edge.join : null;
    }

    public List<Edge> getEdgesByFKSide(TableRef table) {
        if (!this.vertexInfoMap.containsKey(table)) {
            return Collections.emptyList();
        }
        return this.outwardEdges(table);
    }

    private Edge getEdgeByPKSide(TableRef pkTable) {
        if (!this.vertexInfoMap.containsKey(pkTable)) {
            return null;
        }
        List inEdges = this.inwardEdges(pkTable).stream().filter(edge -> !edge.isSwapJoin()).collect(Collectors.toList());
        if (inEdges.size() != 1) {
            return null;
        }
        return (Edge)inEdges.get(0);
    }

    public List<JoinDesc> getJoinsPathByPKSide(TableRef table) {
        ArrayList pathToRoot = Lists.newArrayList();
        TableRef pkSide = table;
        while (pkSide != null) {
            JoinDesc subJoin = this.getJoinByPKSide(pkSide);
            if (Objects.isNull(subJoin)) {
                pkSide = null;
                continue;
            }
            pathToRoot.add(subJoin);
            pkSide = subJoin.getFKSide();
        }
        return Lists.reverse((List)pathToRoot);
    }

    public JoinsGraph getSubGraphByAlias(Set<String> aliasSets) {
        HashSet subJoins = Sets.newHashSet();
        for (String alias : aliasSets) {
            TableRef table = this.vertexMap.get(alias);
            subJoins.addAll(this.getJoinsPathByPKSide(table));
        }
        return new JoinsGraph(this.center, Lists.newArrayList((Iterable)subJoins));
    }

    public List<Edge> unmatched(JoinsGraph pattern) {
        ArrayList unmatched = Lists.newArrayList();
        Set all = this.vertexInfoMap.values().stream().map(m -> m.outEdges).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Edge edge : all) {
            JoinsGraph subGraph = this.getSubGraphByAlias(Sets.newHashSet((Object[])new String[]{edge.pkSide().getAlias()}));
            if (subGraph.match(pattern, Maps.newHashMap())) continue;
            unmatched.add(edge);
        }
        return unmatched;
    }

    public List<Edge> getEdgesByFKSideWithoutSwap(TableRef table) {
        return this.getEdgesByFKSide(table).stream().filter(e -> !e.isSwapJoin()).collect(Collectors.toList());
    }

    public String toString() {
        return this.buildGraphStr(null, 0, false, false);
    }

    public String toString(boolean needSort, boolean useTableIdentity) {
        return this.buildGraphStr(null, 0, needSort, useTableIdentity);
    }

    private String buildGraphStr(Edge edge, int indent, boolean needSort, boolean useTableIdentity) {
        String curNode = indent == 0 ? "Root: " + (useTableIdentity ? this.center.getTableIdentity() : this.center) : IntStream.range(0, indent).mapToObj(i -> "  ").collect(Collectors.joining("", "\n", edge.toString(needSort, useTableIdentity)));
        ArrayList<String> subEdges = new ArrayList<String>();
        for (Edge e : this.getEdgesByFKSideWithoutSwap(indent == 0 ? this.center : edge.pkSide())) {
            subEdges.add(this.buildGraphStr(e, indent + 1, needSort, useTableIdentity));
        }
        if (needSort) {
            subEdges.sort(String::compareTo);
        }
        return curNode + Joiner.on((String)"").join(subEdges);
    }

    private <T> void addIfAbsent(List<T> edges, T edge) {
        if (edges.contains(edge)) {
            return;
        }
        edges.add(edge);
    }

    @Generated
    public TableRef getCenter() {
        return this.center;
    }

    @Generated
    public Map<String, TableRef> getVertexMap() {
        return this.vertexMap;
    }

    static class VertexInfo<E> {
        final List<E> outEdges = new ArrayList();
        final List<E> inEdges = new ArrayList();

        VertexInfo() {
        }
    }
}

