/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.model.Query;

public class QueryRecord
extends RootPersistentEntity {
    @JsonProperty
    private List<Query> queries = Lists.newArrayList();
    @JsonProperty
    private String username;

    public QueryRecord(String project, String username) {
        this.project = project;
        this.username = username;
    }

    public MetadataType resourceType() {
        return MetadataType.QUERY_RECORD;
    }

    public String resourceName() {
        return QueryRecord.generateResourceName(this.project, this.username);
    }

    public static String generateResourceName(String project, String username) {
        return project + "." + username;
    }

    @Generated
    public List<Query> getQueries() {
        return this.queries;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setQueries(List<Query> queries) {
        this.queries = queries;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public QueryRecord() {
    }

    @Generated
    public QueryRecord(List<Query> queries, String username) {
        this.queries = queries;
        this.username = username;
    }
}

