/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealizationCandidate;

public class CapabilityResult {
    private boolean capable = false;
    private IRealizationCandidate selectedCandidate;
    private IRealizationCandidate selectedStreamCandidate;
    private int layoutUnmatchedColsSize;
    private double cost = 2.147483647E9;
    public IncapableCause incapableCause;
    private boolean isVacant;
    private boolean isPartialResult;
    public List<CapabilityInfluence> influences = Lists.newArrayListWithCapacity((int)1);

    public CapabilityResult(IndexMatcher.MatchResult matchResult) {
        this.layoutUnmatchedColsSize = matchResult.getPenalty();
        this.influences = matchResult.getInfluences();
        this.capable = matchResult.isMatched();
    }

    public double getCost(boolean isStreaming) {
        return isStreaming ? this.selectedStreamCandidate.getCost() : this.selectedCandidate.getCost();
    }

    public IRealizationCandidate getSelectedCandidate() {
        return this.selectedCandidate == null ? NLayoutCandidate.ofEmptyCandidate() : this.selectedCandidate;
    }

    public IRealizationCandidate getSelectedStreamCandidate() {
        return this.selectedStreamCandidate == null ? NLayoutCandidate.ofEmptyCandidate() : this.selectedStreamCandidate;
    }

    public void setCandidate(boolean isStreaming, CapabilityResult result) {
        if (isStreaming) {
            this.setSelectedStreamCandidate(result.getSelectedStreamCandidate());
        } else {
            this.setSelectedCandidate(result.getSelectedCandidate());
        }
    }

    public void setCandidate(boolean isStreaming, IRealizationCandidate candidate) {
        if (isStreaming) {
            this.setSelectedStreamCandidate(candidate);
        } else {
            this.setSelectedCandidate(candidate);
        }
    }

    @Generated
    public boolean isCapable() {
        return this.capable;
    }

    @Generated
    public int getLayoutUnmatchedColsSize() {
        return this.layoutUnmatchedColsSize;
    }

    @Generated
    public double getCost() {
        return this.cost;
    }

    @Generated
    public IncapableCause getIncapableCause() {
        return this.incapableCause;
    }

    @Generated
    public boolean isVacant() {
        return this.isVacant;
    }

    @Generated
    public boolean isPartialResult() {
        return this.isPartialResult;
    }

    @Generated
    public List<CapabilityInfluence> getInfluences() {
        return this.influences;
    }

    @Generated
    public void setCapable(boolean capable) {
        this.capable = capable;
    }

    @Generated
    public void setSelectedCandidate(IRealizationCandidate selectedCandidate) {
        this.selectedCandidate = selectedCandidate;
    }

    @Generated
    public void setSelectedStreamCandidate(IRealizationCandidate selectedStreamCandidate) {
        this.selectedStreamCandidate = selectedStreamCandidate;
    }

    @Generated
    public void setLayoutUnmatchedColsSize(int layoutUnmatchedColsSize) {
        this.layoutUnmatchedColsSize = layoutUnmatchedColsSize;
    }

    @Generated
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Generated
    public void setIncapableCause(IncapableCause incapableCause) {
        this.incapableCause = incapableCause;
    }

    @Generated
    public void setVacant(boolean isVacant) {
        this.isVacant = isVacant;
    }

    @Generated
    public void setPartialResult(boolean isPartialResult) {
        this.isPartialResult = isPartialResult;
    }

    @Generated
    public void setInfluences(List<CapabilityInfluence> influences) {
        this.influences = influences;
    }

    @Generated
    public CapabilityResult() {
    }

    public static class IncapableCause {
        private IncapableType incapableType;
        private Collection<TblColRef> unmatchedDimensions;
        private Collection<FunctionDesc> unmatchedAggregations;

        public static IncapableCause unmatchedDimensions(Collection<TblColRef> unmatchedDimensions) {
            IncapableCause incapableCause = new IncapableCause();
            incapableCause.setIncapableType(IncapableType.UNMATCHED_DIMENSION);
            incapableCause.setUnmatchedDimensions(unmatchedDimensions);
            return incapableCause;
        }

        public static IncapableCause create(IncapableType incapableType) {
            IncapableCause incapableCause = new IncapableCause();
            incapableCause.setIncapableType(incapableType);
            return incapableCause;
        }

        @Generated
        public IncapableType getIncapableType() {
            return this.incapableType;
        }

        @Generated
        public Collection<TblColRef> getUnmatchedDimensions() {
            return this.unmatchedDimensions;
        }

        @Generated
        public Collection<FunctionDesc> getUnmatchedAggregations() {
            return this.unmatchedAggregations;
        }

        @Generated
        public void setIncapableType(IncapableType incapableType) {
            this.incapableType = incapableType;
        }

        @Generated
        public void setUnmatchedDimensions(Collection<TblColRef> unmatchedDimensions) {
            this.unmatchedDimensions = unmatchedDimensions;
        }

        @Generated
        public void setUnmatchedAggregations(Collection<FunctionDesc> unmatchedAggregations) {
            this.unmatchedAggregations = unmatchedAggregations;
        }
    }

    public static enum IncapableType {
        UNMATCHED_DIMENSION,
        LIMIT_PRECEDE_AGGR,
        TABLE_INDEX_MISSING_COLS,
        NOT_EXIST_SNAPSHOT;

    }

    public static class DimensionAsMeasure
    implements CapabilityInfluence {
        final FunctionDesc function;

        public DimensionAsMeasure(FunctionDesc function) {
            this.function = function;
        }

        @Override
        public double suggestCostMultiplier() {
            return 1.0;
        }

        @Override
        public MeasureDesc getInvolvedMeasure() {
            return null;
        }

        public FunctionDesc getMeasureFunction() {
            return this.function;
        }
    }

    public static interface CapabilityInfluence {
        public double suggestCostMultiplier();

        public MeasureDesc getInvolvedMeasure();
    }
}

