/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.springframework.util.DigestUtils;

public class RawRecUtil {
    public static final String TABLE_COLUMN_SEPARATOR = "\\$";
    public static final String MEASURE_PARAM_SEPARATOR = "__";

    private RawRecUtil() {
    }

    public static ColumnDesc findColumn(String idOrColumnName, @Nonnull TableDesc tableDesc) {
        ColumnDesc[] columns = tableDesc.getColumns();
        ColumnDesc dependColumn = tableDesc.findColumnByName(idOrColumnName);
        if (dependColumn == null) {
            dependColumn = columns[Integer.parseInt(idOrColumnName)];
        }
        return dependColumn;
    }

    public static String dimensionUniqueContent(TblColRef tblColRef, Map<String, ComputedColumnDesc> ccMap, Set<String> newCcUuids) {
        return RawRecUtil.colUniqueName(tblColRef, ccMap, newCcUuids);
    }

    public static String measureUniqueContent(NDataModel.Measure measure, Map<String, ComputedColumnDesc> ccMap, Set<String> newCcUuids) {
        HashSet paramNames = Sets.newHashSet();
        List<ParameterDesc> parameters = measure.getFunction().getParameters();
        parameters.forEach(param -> {
            TblColRef colRef = param.getColRef();
            if (colRef == null) {
                paramNames.add(String.valueOf(Integer.MAX_VALUE));
                return;
            }
            paramNames.add(RawRecUtil.colUniqueName(colRef, ccMap, newCcUuids));
        });
        return String.format(Locale.ROOT, "%s__%s", measure.getFunction().getExpression(), String.join((CharSequence)MEASURE_PARAM_SEPARATOR, paramNames));
    }

    private static String colUniqueName(TblColRef tblColRef, Map<String, ComputedColumnDesc> ccMap, Set<String> newCcUuids) {
        ComputedColumnDesc cc;
        ColumnDesc columnDesc = tblColRef.getColumnDesc();
        String uniqueName = columnDesc.isComputedColumn() ? (newCcUuids.contains((cc = ccMap.get(columnDesc.getIdentity())).getUuid()) ? cc.getUuid() : tblColRef.getTableRef().getAlias() + "$" + columnDesc.getName()) : tblColRef.getTableRef().getAlias() + "$" + columnDesc.getName();
        return uniqueName;
    }

    public static ComputedColumnDesc getCC(RawRecItem rawRecItem) {
        Preconditions.checkNotNull((Object)rawRecItem);
        Preconditions.checkState((RawRecItem.RawRecType.COMPUTED_COLUMN == rawRecItem.getType() ? 1 : 0) != 0);
        CCRecItemV2 recItemV2 = (CCRecItemV2)rawRecItem.getRecEntity();
        return recItemV2.getCc();
    }

    public static NDataModel.Measure getMeasure(RawRecItem rawRecItem) {
        Preconditions.checkNotNull((Object)rawRecItem);
        Preconditions.checkState((RawRecItem.RawRecType.MEASURE == rawRecItem.getType() ? 1 : 0) != 0);
        MeasureRecItemV2 recItemV2 = (MeasureRecItemV2)rawRecItem.getRecEntity();
        return recItemV2.getMeasure();
    }

    private static LayoutRecItemV2 getLayoutRecItemV2(RawRecItem rawRecItem) {
        Preconditions.checkArgument((rawRecItem != null && rawRecItem.isLayoutRec() ? 1 : 0) != 0);
        return (LayoutRecItemV2)rawRecItem.getRecEntity();
    }

    public static LayoutEntity getLayout(RawRecItem rawRecItem) {
        return RawRecUtil.getLayoutRecItemV2(rawRecItem).getLayout();
    }

    public static String getContent(RawRecItem recItem) {
        return RawRecUtil.getContent(recItem.getProject(), recItem.getModelID(), recItem.getRecEntity().getUniqueContent(), recItem.getType());
    }

    public static String getContent(String project, String model, String uniqueContent, RawRecItem.RawRecType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(project).append(',');
        sb.append(model).append(',');
        sb.append(uniqueContent).append(',');
        sb.append((Object)type);
        return sb.toString();
    }

    public static String computeMD5(String content) {
        return DigestUtils.md5DigestAsHex((byte[])content.getBytes(Charset.defaultCharset()));
    }

    public static Map<String, List<String>> uniqueFlagsToMd5Map(Set<String> uniqueFlags) {
        HashMap md5ToFlags = Maps.newHashMap();
        uniqueFlags.forEach(uniqueFlag -> {
            if (uniqueFlag != null) {
                String md5 = uniqueFlag.substring(0, 32);
                List flags = md5ToFlags.getOrDefault(md5, new ArrayList());
                flags.add(uniqueFlag);
                md5ToFlags.put(md5, flags);
            }
        });
        return md5ToFlags;
    }

    public static Pair<String, RawRecItem> getRawRecItemFromMap(String md5, String content, Map<String, List<String>> md5ToFlags, Map<String, RawRecItem> uniqueRecItemMap) {
        List flags = md5ToFlags.getOrDefault(md5, new ArrayList());
        int maxItemId = 0;
        for (String flag : flags) {
            RawRecItem item = uniqueRecItemMap.get(flag);
            if (RawRecUtil.getContent(item).equals(content)) {
                return Pair.newPair((Object)flag, (Object)item);
            }
            maxItemId = Math.max(item.getId(), maxItemId);
        }
        if (!flags.contains(md5)) {
            return Pair.newPair((Object)md5, null);
        }
        String uniqueFlag = String.format(Locale.ROOT, "%s_%d", md5, maxItemId);
        return Pair.newPair((Object)uniqueFlag, null);
    }
}

