/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.state;

import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.state.ShareStateInfo;
import org.apache.kylin.metadata.state.ShareStateMapper;
import org.apache.kylin.metadata.state.ShareStateTable;
import org.apache.kylin.metadata.state.ShareStateUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcShareStateStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcShareStateStore.class);
    private final ShareStateTable shareStateTable;
    private final SqlSessionFactory sqlSessionFactory;
    private final DataSource dataSource;
    String ssTableName;

    public static JdbcShareStateStore getInstance() {
        return (JdbcShareStateStore)Singletons.getInstance(JdbcShareStateStore.class);
    }

    private JdbcShareStateStore() throws Exception {
        StorageURL url = KylinConfig.getInstanceFromEnv().getJdbcShareStateUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        this.dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.ssTableName = StorageURL.replaceUrl((StorageURL)url) + "_share_state";
        this.shareStateTable = new ShareStateTable(this.ssTableName);
        this.sqlSessionFactory = ShareStateUtil.getSqlSessionFactory(this.dataSource, this.ssTableName);
    }

    public int insert(String instanceName, String shareState) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            ShareStateMapper ssMapper = (ShareStateMapper)session.getMapper(ShareStateMapper.class);
            ShareStateInfo shareStateInfoObj = new ShareStateInfo(instanceName, shareState);
            InsertStatementProvider<ShareStateInfo> insertStatement = this.getInsertShareStateProvider(shareStateInfoObj);
            int rows = ssMapper.insert(insertStatement);
            log.debug("Insert {} items into database, instanceName:{}", (Object)rows, (Object)instanceName);
            session.commit();
            int n = rows;
            return n;
        }
    }

    InsertStatementProvider<ShareStateInfo> getInsertShareStateProvider(ShareStateInfo shareStateInfo) {
        return SqlBuilder.insert((Object)shareStateInfo).into((SqlTable)this.shareStateTable).map(this.shareStateTable.instanceName).toPropertyWhenPresent("instanceName", shareStateInfo::getInstanceName).map(this.shareStateTable.shareState).toPropertyWhenPresent("shareState", shareStateInfo::getShareState).build().render(RenderingStrategies.MYBATIS3);
    }

    public void update(String instanceName, String shareState) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            ShareStateMapper ssMapper = (ShareStateMapper)session.getMapper(ShareStateMapper.class);
            UpdateStatementProvider updateStatement = this.getUpdateShareStateProvider(instanceName, shareState);
            ssMapper.update(updateStatement);
            session.commit();
        }
    }

    private UpdateStatementProvider getUpdateShareStateProvider(String instanceName, String shareState) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.shareStateTable).set(this.shareStateTable.shareState).equalTo((Object)shareState).where(this.shareStateTable.instanceName, (VisitableCondition)SqlBuilder.isEqualTo((Object)instanceName), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    public ShareStateInfo selectShareStateByInstanceName(String instanceName) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            ShareStateMapper ssMapper = (ShareStateMapper)session.getMapper(ShareStateMapper.class);
            SelectStatementProvider selectStatement = this.getSelectShareStateProvider(instanceName);
            ShareStateInfo shareStateInfo = ssMapper.selectOne(selectStatement);
            return shareStateInfo;
        }
    }

    private SelectStatementProvider getSelectShareStateProvider(String instanceName) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.shareStateTable)).from((SqlTable)this.shareStateTable).where(this.shareStateTable.instanceName, (VisitableCondition)SqlBuilder.isEqualTo((Object)instanceName), new AndOrCriteriaGroup[0])).limit(1L).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(ShareStateTable shareStateTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{shareStateTable.instanceName, shareStateTable.shareState});
    }

    @Generated
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

