/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.table;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.table.InternalTablePartition;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class InternalTableDesc
extends ATable
implements Serializable {
    private static final String BUCKET_COLUMN = "bucketCol";
    private static final String BUCKET_NUM = "bucketNum";
    private static final String PRELOADED_CACHE = "preloadedCache";
    private static final String PRIMARY_KEY = "primaryKey";
    private static final String SORT_BY_KEY = "sortByKey";
    private static final String SORT_BY_PARTITION_BEFORE_SAVE = "sortByPartition";
    public static final int INIT_SIZE = 0;
    @JsonProperty(value="tbl_properties")
    private Map<String, String> tblProperties;
    @JsonProperty(value="storage_type")
    private StorageType storageType;
    @JsonProperty(value="storage_size")
    private long storageSize = 0L;
    @JsonProperty(value="row_count")
    private long rowCount = 0L;
    @JsonProperty(value="hit_count")
    private long hitCount = 0L;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="partition_range")
    private List<String[]> partitionRange;
    @JsonProperty(value="job_range")
    private List<String[]> jobRange;
    @JsonProperty(value="table_partition")
    private InternalTablePartition tablePartition;

    public InternalTableDesc(InternalTableDesc other) {
        this.project = other.project;
        this.database.setName(other.getDatabase());
        this.tblProperties = other.tblProperties;
        this.storageType = other.storageType;
        this.location = other.location;
        this.tablePartition = other.tablePartition;
        this.storageSize = other.storageSize;
        this.jobRange = other.jobRange;
        this.partitionRange = other.partitionRange;
        this.setMvcc(other.getMvcc());
    }

    public InternalTableDesc(TableDesc originTable) {
        this.project = originTable.getProject();
        this.database.setName(originTable.getDatabase());
        this.name = originTable.getName();
        this.columns = originTable.getColumns();
        this.uuid = RandomUtil.randomUUIDStr();
        this.jobRange = Lists.newArrayList();
        this.partitionRange = Lists.newArrayList();
        this.lastModified = 0L;
    }

    public void optimizeTblProperties() {
        Map<String, String> properties = this.getTblProperties();
        HashMap optimizedProperties = Maps.newHashMap();
        properties.forEach((k, v) -> {
            if (!StringUtils.isEmpty((CharSequence)v)) {
                optimizedProperties.put(k, v);
            }
        });
        this.setTblProperties(optimizedProperties);
    }

    @Override
    public void init(String project) {
        super.init(project);
    }

    public String getDoubleQuoteInternalIdentity() {
        return String.format(Locale.ROOT, "\"INTERNAL_CATALOG\".\"%s\".\"%s\".\"%s\"", this.project, this.getDatabase(), this.getName());
    }

    public void setStorageType(String storageType) {
        if (storageType == null) {
            this.storageType = StorageType.GLUTEN;
        } else {
            String storageTypeUpper = storageType.toUpperCase(Locale.ROOT);
            this.storageType = StorageType.valueOf(storageTypeUpper);
        }
    }

    public String getBucketColumn() {
        if (null == this.tblProperties.get(BUCKET_COLUMN)) {
            return null;
        }
        return this.tblProperties.get(BUCKET_COLUMN).trim();
    }

    public int getBucketNumber() {
        if (null == this.tblProperties.get(BUCKET_NUM)) {
            return 0;
        }
        return Integer.parseInt(this.tblProperties.get(BUCKET_NUM).trim());
    }

    public List<String> getPrimaryKey() {
        return Arrays.stream(StringUtils.split((String)this.tblProperties.get(PRIMARY_KEY), (String)",")).map(String::trim).collect(Collectors.toList());
    }

    public List<String> getSortByKey() {
        return Arrays.stream(StringUtils.split((String)this.tblProperties.get(SORT_BY_KEY), (String)",")).map(String::trim).collect(Collectors.toList());
    }

    public boolean isPreloadedCacheEnable() {
        return Boolean.parseBoolean(this.tblProperties.getOrDefault(PRELOADED_CACHE, "false"));
    }

    public boolean isSortByPartitionEnabled() {
        if (this.tblProperties.containsKey(SORT_BY_PARTITION_BEFORE_SAVE)) {
            return Boolean.parseBoolean(this.tblProperties.get(SORT_BY_PARTITION_BEFORE_SAVE));
        }
        return NProjectManager.getProjectConfig(this.project).isInternalTableSortByPartitionEnabled();
    }

    public String generateInternalTableLocation() {
        String workingDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        return workingDir + this.project + "/Internal/" + this.getDatabase() + "/" + this.getName();
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String[] getPartitionColumns() {
        return this.tablePartition == null ? null : this.tablePartition.getPartitionColumns();
    }

    public String getDatePartitionFormat() {
        return this.tablePartition == null ? null : this.tablePartition.getDatePartitionFormat();
    }

    public MetadataType resourceType() {
        return MetadataType.INTERNAL_TABLE;
    }

    public TableDesc getTableDesc() {
        return NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), this.getProject()).getTableDesc(this.getIdentity());
    }

    @Generated
    public void setTblProperties(Map<String, String> tblProperties) {
        this.tblProperties = tblProperties;
    }

    @Generated
    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    @Generated
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setPartitionRange(List<String[]> partitionRange) {
        this.partitionRange = partitionRange;
    }

    @Generated
    public void setJobRange(List<String[]> jobRange) {
        this.jobRange = jobRange;
    }

    @Generated
    public void setTablePartition(InternalTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    @Generated
    public Map<String, String> getTblProperties() {
        return this.tblProperties;
    }

    @Generated
    public long getStorageSize() {
        return this.storageSize;
    }

    @Generated
    public long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public long getHitCount() {
        return this.hitCount;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public List<String[]> getPartitionRange() {
        return this.partitionRange;
    }

    @Generated
    public List<String[]> getJobRange() {
        return this.jobRange;
    }

    @Generated
    public InternalTablePartition getTablePartition() {
        return this.tablePartition;
    }

    @Generated
    public InternalTableDesc() {
    }

    public static enum StorageType {
        PARQUET("parquet"),
        GLUTEN("clickhouse"),
        DELTALAKE("delta"),
        ICEBERG("iceberg");

        private final String format;

        private StorageType(String format) {
            this.format = format;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }
    }
}

