/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.upgrade;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.upgrade.GlobalAclVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalAclVersionManager {
    private static final Logger logger = LoggerFactory.getLogger(GlobalAclVersionManager.class);
    private KylinConfig config;
    private CachedCrudAssist<GlobalAclVersion> crud;

    public static GlobalAclVersionManager getInstance(KylinConfig config) {
        return (GlobalAclVersionManager)config.getManager(GlobalAclVersionManager.class);
    }

    static GlobalAclVersionManager newInstance(KylinConfig config) {
        return new GlobalAclVersionManager(config);
    }

    public GlobalAclVersionManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing AclVersionManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<GlobalAclVersion>(this.getStore(), MetadataType.SYSTEM, null, GlobalAclVersion.class){

            @Override
            protected GlobalAclVersion initEntityAfterReload(GlobalAclVersion globalAclVersion, String resourceName) {
                return globalAclVersion;
            }
        };
        this.crud.reloadAll();
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public boolean exists() {
        return this.crud.exists("acl_version");
    }

    private GlobalAclVersion copyForWrite(GlobalAclVersion globalAclVersion) {
        return this.crud.copyForWrite(globalAclVersion);
    }

    public void save(GlobalAclVersion globalAclVersion) {
        Preconditions.checkNotNull((Object)globalAclVersion.getAclVersion());
        GlobalAclVersion copy = this.copyForWrite(globalAclVersion);
        if (!this.exists()) {
            this.crud.save(copy);
        }
    }

    public void delete() {
        if (this.exists()) {
            this.crud.delete("acl_version");
        }
    }
}

