/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.UserAcl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.model.Permission;

public class UserAclManager {
    private static final Logger logger = LoggerFactory.getLogger(UserAclManager.class);
    private KylinConfig config;
    private CachedCrudAssist<UserAcl> crud;

    public static UserAclManager getInstance(KylinConfig config) {
        return (UserAclManager)config.getManager(UserAclManager.class);
    }

    static UserAclManager newInstance(KylinConfig config) {
        return new UserAclManager(config);
    }

    public UserAclManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing UserAclManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<UserAcl>(this.getStore(), MetadataType.USER_GLOBAL_ACL, null, UserAcl.class){

            @Override
            protected UserAcl initEntityAfterReload(UserAcl userAcl, String resourceName) {
                return userAcl;
            }
        };
        this.crud.reloadAll();
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public List<String> listAclUsernames() {
        return ImmutableList.copyOf((Collection)this.crud.listAll().stream().map(UserAcl::getUsername).collect(Collectors.toList()));
    }

    public List<UserAcl> listUserAcl() {
        return ImmutableList.copyOf(this.crud.listAll());
    }

    public boolean exists(String name) {
        return this.filterUsername(name).isPresent();
    }

    public Optional<String> filterUsername(String username) {
        return this.listAclUsernames().stream().filter(name -> StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)username)).findAny();
    }

    public UserAcl get(String name) {
        Optional<String> username = this.filterUsername(name);
        return username.isPresent() ? this.crud.get(username.get()) : null;
    }

    public void add(String name) {
        this.addPermission(name, AclPermission.DATA_QUERY);
    }

    public void delete(String name) {
        Optional<String> username = this.filterUsername(name);
        if (username.isPresent()) {
            this.crud.delete(username.get());
        }
    }

    public void addPermission(String name, Permission permission) {
        this.addPermission(name, Sets.newHashSet((Object[])new Permission[]{permission}));
    }

    public void addPermission(String name, Set<Permission> permissions) {
        Optional<String> username = this.filterUsername(name);
        if (!username.isPresent()) {
            UserAcl userAcl = this.crud.copyForWrite(new UserAcl(name, permissions));
            this.crud.save(userAcl);
        } else {
            UserAcl userAcl = this.get(username.get());
            this.updateAcl(userAcl, acl -> permissions.forEach(acl::addPermission));
        }
    }

    public void addDataQueryProject(String name, String project) {
        Optional<String> username = this.filterUsername(name);
        if (!username.isPresent()) {
            UserAcl userAcl = this.crud.copyForWrite(new UserAcl(name, Collections.emptySet()));
            userAcl.addDataQueryProject(project);
            this.crud.save(userAcl);
        } else {
            UserAcl userAcl = this.get(username.get());
            if (!userAcl.hasPermission(AclPermission.DATA_QUERY)) {
                this.updateAcl(userAcl, acl -> acl.addDataQueryProject(project));
            }
        }
    }

    public void deletePermission(String name, Permission permission) {
        Optional<String> username = this.filterUsername(name);
        if (!username.isPresent()) {
            return;
        }
        UserAcl userAcl = this.get(username.get());
        this.updateAcl(userAcl, acl -> {
            acl.deletePermission(permission);
            acl.setDataQueryProjects(Collections.emptyList());
        });
    }

    public void deleteDataQueryProject(String name, String project) {
        Optional<String> username = this.filterUsername(name);
        if (!username.isPresent()) {
            return;
        }
        UserAcl userAcl = this.get(username.get());
        if (!userAcl.hasPermission(AclPermission.DATA_QUERY)) {
            this.updateAcl(userAcl, acl -> acl.deleteDataQueryProject(project));
        }
    }

    private UserAcl updateAcl(UserAcl acl, UserAclUpdater updater) {
        UserAcl copyForWrite = this.crud.copyForWrite(acl);
        updater.update(copyForWrite);
        this.crud.save(copyForWrite);
        return this.get(acl.getUsername());
    }

    public static interface UserAclUpdater {
        public void update(UserAcl var1);
    }
}

