/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.Map;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.user.ManagedUser;

public class UserLockRuleUtil {
    private static final Map<Integer, Long> lockDurationRules = Maps.newHashMap();

    private UserLockRuleUtil() {
    }

    public static long getLockDuration(int wrongTime) {
        if (wrongTime >= 0 && wrongTime <= 10) {
            return lockDurationRules.get(wrongTime);
        }
        return lockDurationRules.get(10);
    }

    public static long getLockDurationSeconds(int wrongTime) {
        long lockDurationMs = UserLockRuleUtil.getLockDuration(wrongTime);
        return lockDurationMs / 1000L;
    }

    public static long getLockDurationSeconds(ManagedUser managedUser) {
        return UserLockRuleUtil.getLockDurationSeconds(managedUser.getWrongTime());
    }

    public static boolean isLockedPermanently(ManagedUser managedUser) {
        return Long.MAX_VALUE == lockDurationRules.get(managedUser.getWrongTime());
    }

    public static boolean isLockDurationEnded(ManagedUser managedUser, long duration) {
        return duration >= UserLockRuleUtil.getLockDuration(managedUser.getWrongTime());
    }

    public static long getLockLeftSeconds(ManagedUser managedUser, long duration) {
        long lockDuration = UserLockRuleUtil.getLockDuration(managedUser.getWrongTime());
        if (Long.MAX_VALUE == lockDuration) {
            return Long.MAX_VALUE;
        }
        long leftSeconds = (lockDuration - duration) / 1000L;
        return leftSeconds <= 0L ? 1L : leftSeconds;
    }

    static {
        lockDurationRules.put(0, 0L);
        lockDurationRules.put(1, 0L);
        lockDurationRules.put(2, 0L);
        lockDurationRules.put(3, 30000L);
        lockDurationRules.put(4, 60000L);
        lockDurationRules.put(5, 300000L);
        lockDurationRules.put(6, 600000L);
        lockDurationRules.put(7, 1800000L);
        lockDurationRules.put(8, 86400000L);
        lockDurationRules.put(9, 259200000L);
        lockDurationRules.put(10, Long.MAX_VALUE);
    }
}

