/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Database {
    private static final Logger logger = LoggerFactory.getLogger(H2Database.class);
    private static final String[] ALL_TABLES_DROP = new String[]{"`edw`.`test_cal_dt`", "`default`.`test_category_groupings`", "`default`.`test_kylin_fact`", "`default`.`test_order`", "`edw`.`test_seller_type_dim`", "`edw`.`test_sites`", "`default`.`test_account`", "`default`.`test_country`", "`ssb`.`customer`", "`ssb`.`dates`", "`ssb`.`p_lineorder`", "`ssb`.`lineorder`", "`ssb`.`part`", "`ssb`.`supplier`"};
    private static final String[] ALL_TABLES = new String[]{"edw.test_cal_dt", "default.test_category_groupings", "default.test_kylin_fact", "default.test_order", "edw.test_seller_type_dim", "edw.test_sites", "default.test_account", "default.test_country", "ssb.customer", "ssb.dates", "ssb.p_lineorder", "ssb.lineorder", "ssb.part", "ssb.supplier"};
    private static final Map<String, String> javaToH2DataTypeMapping = new HashMap<String, String>();
    private final Connection h2Connection;
    private final KylinConfig config;
    private final String project;

    public H2Database(Connection h2Connection, KylinConfig config, String prj) {
        this.h2Connection = h2Connection;
        this.config = config;
        this.project = prj;
    }

    private static String getH2DataType(String javaDataType) {
        String hiveDataType = javaToH2DataTypeMapping.get(javaDataType.toLowerCase(Locale.ROOT));
        if (hiveDataType == null) {
            hiveDataType = javaDataType;
        }
        return hiveDataType.toLowerCase(Locale.ROOT);
    }

    public void loadAllTables() throws SQLException {
        for (String tableName : ALL_TABLES) {
            this.loadH2Table(tableName);
        }
    }

    public void dropAll() throws SQLException {
        try (Statement stmt = this.h2Connection.createStatement();){
            StringBuilder sqlBuilder = new StringBuilder();
            for (String tblName : ALL_TABLES_DROP) {
                sqlBuilder.append("DROP TABLE IF EXISTS ").append(tblName).append(";\n");
            }
            sqlBuilder.append("DROP SCHEMA IF EXISTS `DEFAULT`;\nDROP SCHEMA IF EXISTS `EDW`;\nDROP SCHEMA IF EXISTS `SSB`;");
            stmt.executeUpdate(sqlBuilder.toString());
        }
    }

    private void loadH2Table(String tableName) throws SQLException {
        NTableMetadataManager metaMgr = NTableMetadataManager.getInstance(this.config, this.project);
        TableDesc tableDesc = metaMgr.getTableDesc(tableName.toUpperCase(Locale.ROOT));
        String path = this.path(tableDesc);
        try {
            File tempFile = File.createTempFile("tmp_h2", ".csv");
            try (FileOutputStream tempFileStream = new FileOutputStream(tempFile);){
                try (InputStream is = Files.newInputStream(Paths.get(this.config.getMetadataUrl().getIdentifier(), "..", path).toFile().toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)is, (OutputStream)tempFileStream);
                }
                String cvsFilePath = tempFile.getPath();
                try (Statement stmt = this.h2Connection.createStatement();){
                    String createDBSql = "CREATE SCHEMA IF NOT EXISTS `DEFAULT`;\nCREATE SCHEMA IF NOT EXISTS `EDW`;\nCREATE SCHEMA IF NOT EXISTS `SSB`;\nSET SCHEMA `DEFAULT`;\n";
                    stmt.executeUpdate(createDBSql);
                    String sql = this.generateCreateH2TableSql(tableDesc, cvsFilePath);
                    stmt.executeUpdate(sql);
                    List<String> createIndexStatements = this.generateCreateH2IndexSql(tableDesc);
                    for (String indexSql : createIndexStatements) {
                        stmt.executeUpdate(indexSql);
                    }
                }
            }
            FileUtils.deleteQuietly((File)tempFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String path(TableDesc tableDesc) {
        if ("EDW.TEST_SELLER_TYPE_DIM".equals(tableDesc.getIdentity())) {
            return "/data/EDW.TEST_SELLER_TYPE_DIM.csv";
        }
        return "/data/" + tableDesc.getIdentity() + ".csv";
    }

    private String generateCreateH2TableSql(TableDesc tableDesc, String csvFilePath) {
        StringBuilder ddl = new StringBuilder();
        StringBuilder csvColumns = new StringBuilder();
        ddl.append("CREATE TABLE IF NOT EXISTS `" + tableDesc.getDatabase() + "`.`" + tableDesc.getName() + "`\n");
        ddl.append("(\n");
        for (int i = 0; i < tableDesc.getColumns().length; ++i) {
            ColumnDesc col = tableDesc.getColumns()[i];
            if (col.isComputedColumn()) continue;
            if (i > 0) {
                ddl.append(",");
                csvColumns.append(",");
            }
            ddl.append(col.getName()).append(" ").append(H2Database.getH2DataType(col.getDatatype())).append("\n");
            csvColumns.append(col.getName());
        }
        ddl.append(")\n");
        ddl.append("AS SELECT * FROM CSVREAD('").append(csvFilePath).append("', '").append((CharSequence)csvColumns).append("', 'charset=UTF-8 fieldSeparator=,');");
        return ddl.toString();
    }

    private List<String> generateCreateH2IndexSql(TableDesc tableDesc) {
        ArrayList result = Lists.newArrayList();
        int x = 0;
        for (ColumnDesc col : tableDesc.getColumns()) {
            if (!"T".equalsIgnoreCase(col.getIndex())) continue;
            StringBuilder ddl = new StringBuilder();
            ddl.append("CREATE INDEX IF NOT EXISTS IDX_").append(tableDesc.getName()).append("_").append(x).append(" ON ").append("`").append(tableDesc.getDatabase()).append("`.`").append(tableDesc.getName()).append("`(").append(col.getName()).append(")");
            ddl.append("\n");
            result.add(ddl.toString());
            ++x;
        }
        return result;
    }

    static {
        javaToH2DataTypeMapping.put("short", "smallint");
        javaToH2DataTypeMapping.put("long", "bigint");
        javaToH2DataTypeMapping.put("byte", "tinyint");
        javaToH2DataTypeMapping.put("string", "varchar");
    }
}

