/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.util.DumpInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDumpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataDumpUtil.class);
    private static final String EMPTY = "";

    public static void dumpMetadata(DumpInfo info) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String metaDumpUrl = info.getDistMetaUrl();
        if (StringUtils.isEmpty((CharSequence)metaDumpUrl)) {
            throw new RuntimeException("Missing metaUrl");
        }
        Properties props = config.exportToProperties();
        props.setProperty("kylin.metadata.url", metaDumpUrl);
        KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
        MetadataStore dstMetadataStore = MetadataStore.createMetadataStore((KylinConfig)dstConfig);
        if (info.getType() == DumpInfo.DumpType.DATA_LOADING) {
            MetadataDumpUtil.dumpMetadataViaTmpDir(config, dstMetadataStore, info);
        } else if (info.getType() == DumpInfo.DumpType.ASYNC_QUERY) {
            dstMetadataStore.dump(ResourceStore.getKylinMetaStore((KylinConfig)config), info.getMetadataDumpList());
        }
        log.debug("Dump metadata finished.");
    }

    private static void dumpMetadataViaTmpDir(KylinConfig config, MetadataStore dstMetadataStore, DumpInfo info) throws IOException {
        File tmpDir = File.createTempFile("kylin_job_meta", EMPTY);
        FileUtils.forceDelete((File)tmpDir);
        Map dumpMap = (Map)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(UnitOfWorkParams.builder().readonly(true).unitName(info.getProject()).maxRetry(1).processor(() -> {
            HashMap retMap = Maps.newHashMap();
            for (String resPath : info.getMetadataDumpList()) {
                ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
                RawResource rawResource = resourceStore.getResource(resPath);
                retMap.put(resPath, rawResource);
            }
            return retMap;
        }).build());
        if (Objects.isNull(dumpMap) || dumpMap.isEmpty()) {
            return;
        }
        ResourceStore.dumpResourceMaps((File)tmpDir, (Map)dumpMap);
        dstMetadataStore.uploadFromFile(tmpDir);
        log.debug("Copied metadata to the target metaUrl, delete the temp dir: {}", (Object)tmpDir);
        FileUtils.forceDelete((File)tmpDir);
    }
}

