/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.context.ApplicationListener;
import org.springframework.session.events.AbstractSessionEvent;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.web.http.HttpSessionAdapter;
import org.springframework.web.context.ServletContextAware;

public class SessionEventHttpSessionListenerAdapter
implements ApplicationListener<AbstractSessionEvent>,
ServletContextAware {
    private final List<HttpSessionListener> listeners;
    private ServletContext context;

    public SessionEventHttpSessionListenerAdapter(List<HttpSessionListener> listeners) {
        this.listeners = listeners;
    }

    public void onApplicationEvent(AbstractSessionEvent event) {
        if (this.listeners.isEmpty()) {
            return;
        }
        HttpSessionEvent httpSessionEvent = this.createHttpSessionEvent(event);
        for (HttpSessionListener listener : this.listeners) {
            if (event instanceof SessionDestroyedEvent) {
                listener.sessionDestroyed(httpSessionEvent);
                continue;
            }
            if (!(event instanceof SessionCreatedEvent)) continue;
            listener.sessionCreated(httpSessionEvent);
        }
    }

    private HttpSessionEvent createHttpSessionEvent(AbstractSessionEvent event) {
        Object session = event.getSession();
        HttpSessionAdapter httpSession = new HttpSessionAdapter(session, this.context);
        return new HttpSessionEvent(httpSession);
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }
}

